/***************************************************************************
                         playerwidget.h  -  description
                            -------------------
   begin                : Mit Nov 20 2002
   copyright            : (C) 2002 by Mark Kretschmann
   email                : markey@web.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYERWIDGET_H
#define PLAYERWIDGET_H

#include <tqpixmap.h>     //stack allocated
#include <tqtoolbutton.h> //baseclass
#include <tqvaluevector.h>//stack allocated
#include <tqwidget.h>     //baseclass

#include "engineobserver.h" //baseclass

namespace Amarok { class PrettySlider; }
class TDEAction;
class MetaBundle;
class PlayerWidget;
class TQBitmap;
class TQButton;
class TQHBox;
class TQLabel;
class TQString;
class TQStringList;
class TQTimerEvent;


class NavButton : public TQToolButton //no TQOBJECT macro - why bother?
{
public:
    NavButton( TQWidget*, const TQString&, TDEAction* );

protected:
    void timerEvent( TQTimerEvent* );
    void drawButtonLabel( TQPainter* );

    static const int GLOW_INTERVAL = 35;
    static const int NUMPIXMAPS    = 16;

    TQPixmap m_pixmapOff;
    TQPixmap m_pixmapDisabled;

    TQValueVector<TQPixmap> m_glowPixmaps;
    int m_glowIndex;
};


class IconButton : public TQButton
{
    Q_OBJECT
  

public:
    IconButton( TQWidget*, const TQString&, const char *signal );
    IconButton( TQWidget*, const TQString&, TQObject* receiver, const char *slot );

public slots:
    void setOn( bool b ) { TQButton::setOn( b ); }
    void setOff()        { TQButton::setOn( false ); }

private:
    void drawButton( TQPainter* );

    const TQPixmap m_up;
    const TQPixmap m_down;
};


class PlayerWidget : public TQWidget, public EngineObserver
{
        Q_OBJECT
  

    public:
        PlayerWidget( TQWidget* = 0, const char* = 0, bool enablePlaylist = false );
        ~PlayerWidget();

        /** Set modified Amarok palette */
        void setModifiedPalette();
        /** Call after some Amarok setting have changed */
        void applySettings();

        bool isMinimalView() { return m_minimalView; }
        void setMinimalView( bool enable );

        virtual void startDrag();

        /** Determines Amarok colours for current KDE scheme */
        static void determineAmarokColors();

    public slots:
        void createAnalyzer( int = 0 );
        void toggleView() { setMinimalView( !m_minimalView ); }


    protected:
        /** Observer reimpls **/
        void engineStateChanged( Engine::State state, Engine::State oldstate = Engine::Empty );
        void engineVolumeChanged( int percent );
        void engineNewMetaData( const MetaBundle &/*bundle*/, bool /*trackChanged*/ );
        void engineTrackPositionChanged( long /*position*/, bool /*userSeek*/ );
        void engineTrackLengthChanged( long length );

    signals:
        void playlistToggled( bool on );

    private slots:
        void drawScroll();
        void timeDisplay( int );
        void slotShowEqualizer( bool show );

    private:
        void setScroll( const TQStringList& );

        virtual bool event( TQEvent* );
        virtual bool eventFilter( TQObject*, TQEvent* );
        //virtual bool x11Event( XEvent* );
        virtual void paintEvent( TQPaintEvent* );
        virtual void contextMenuEvent( TQMouseEvent* );
        virtual void mousePressEvent( TQMouseEvent* );
        virtual void mouseMoveEvent( TQMouseEvent* );

        ///to make the code clearer to n00bies ;)
        TQWidget *playlistWindow() { return parentWidget(); }

        static const int SCROLL_RATE = 1;
        static const int ANIM_TIMER  = 30;

        // ATTRIBUTES ------
        bool     m_minimalView;

        TQTimer  *m_pAnimTimer;

        TQPixmap m_scrollTextPixmap;
        TQPixmap m_scrollBuffer;
        TQPixmap m_timeBuffer;
        TQPixmap m_plusPixmap;
        TQPixmap m_minusPixmap;

        TQPoint  m_startDragPos; //for drag behaviour

        //widgets
        TQString      m_rateString;
        TQWidget     *m_pAnalyzer;
        IconButton  *m_pButtonEq;
        IconButton  *m_pPlaylistButton;
        TQLabel      *m_pTimeLabel;
        TQLabel      *m_pTimeSign;

        TQFrame  *m_pScrollFrame;
        TQLabel  *m_pVolSign;
        TQLabel  *m_pDescription;
        TQHBox   *m_pFrameButtons;

        Amarok::PrettySlider *m_pSlider;
        Amarok::PrettySlider *m_pVolSlider;
        TQToolButton    *m_pButtonPlay;
        TQToolButton    *m_pButtonPause;

        TQString m_currentURL;
};

#endif
