/***************************************************************************
 * copyright            : (C) 2005 Seb Ruiz <me@sebruiz.net>               *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMAROK_QUEUEMANAGER_H
#define AMAROK_QUEUEMANAGER_H

#include "playlistitem.h"

#include <kdialogbase.h>    //baseclass
#include <tdelistview.h>      //baseclass

#include <tqmap.h>

class KPushButton;

class QueueItem : public TDEListViewItem
{
    public:
        QueueItem( TQListView *parent, TQListViewItem *after, TQString t )
            : TDEListViewItem( parent, after, t )
        { };

        void paintCell( TQPainter *p, const TQColorGroup &cg, int column, int width, int align );

};

class QueueList : public TDEListView
{
        Q_OBJECT
  

    friend class QueueManager;

    public:
        QueueList( TQWidget *parent, const char *name = 0 );
        ~QueueList() {};

        bool    hasSelection();
        bool    isEmpty() { return ( childCount() == 0 ); }
        TQPtrList<TQListViewItem>  selectedItems();

    public slots:
        void    moveSelectedUp();
        void    moveSelectedDown();
        void    removeSelected();
        virtual void    clear();

    private:
        void    contentsDragEnterEvent( TQDragEnterEvent *e );
        void    contentsDragMoveEvent( TQDragMoveEvent* e );
        void    contentsDropEvent( TQDropEvent *e );
        void    keyPressEvent( TQKeyEvent *e );
        void    viewportPaintEvent( TQPaintEvent* );

     signals:
        void    changed();
};

class QueueManager : public KDialogBase
{
        Q_OBJECT
  

    public:
        QueueManager( TQWidget *parent = 0, const char *name = 0 );
        ~QueueManager();

        TQPtrList<PlaylistItem> newQueue();

        static QueueManager *instance() { return s_instance; }

    public slots:
        void    applyNow();
        void    addItems( TQListViewItem *after = 0 ); /// For the add button (uses selected playlist tracks)
        void    changeQueuedItems( const PLItemList &in, const PLItemList &out );  /// For keeping queue/dequeue in sync
        void    updateButtons();

    private slots:
        void    removeSelected();
        void    changed();

    private:
        void    insertItems();
        void    addQueuedItem( PlaylistItem *item );
        void    removeQueuedItem( PlaylistItem *item );

        TQMap<TQListViewItem*, PlaylistItem*> m_map;
        QueueList   *m_listview;
        KPushButton *m_up;
        KPushButton *m_down;
        KPushButton *m_remove;
        KPushButton *m_add;
        KPushButton *m_clear;

        static QueueManager *s_instance;
};

#endif /* AMAROK_QUEUEMANAGER_H */
