// (c) 2005 Ian Monroe <ian@monroe.nu>
// See COPYING file for licensing information.

#ifndef AMAROK_REFRESHIMAGES_H
#define AMAROK_REFRESHIMAGES_H

#include <tqobject.h>
namespace TDEIO {
    class StoredTransferJob;
    class Job;
}
class TQStringList;

class JobInfo
{
  public:
    JobInfo() : m_last(false) { } //for TQMap
    JobInfo(const TQString& asin, const TQString& locale, bool last) :
      m_asin(asin), m_locale(locale), m_last(last) { }
    TQString m_asin;
    TQString m_locale;
    TQString m_detailUrl;
    bool m_last;
};

class RefreshImages : public TQObject
{
    Q_OBJECT
  
  public:
    RefreshImages();
  private slots:
    void finishedXmlFetch( TDEIO::Job* );
    void finishedImageFetch( TDEIO::Job* );
  private:
    static TQString localeToTLD(const TQString& locale);
    TQMap<TQString, JobInfo> m_jobInfo;
};
#endif
