/***************************************************************************
 * copyright            : (C) 2005-2006 Seb Ruiz <me@sebruiz.net>          *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMAROK_STATISTICS_H
#define AMAROK_STATISTICS_H

#include "playlistwindow.h"

#include <kdialogbase.h>    //baseclass
#include <tdelistview.h>      //baseclass

#include <tqtimer.h>

class ClickLineEdit;
class TQColor;
class TQTimer;

class StatisticsList;
class StatisticsItem;
class StatisticsDetailedItem;

class Statistics : public KDialogBase
{
        Q_OBJECT
  

    public:
        Statistics( TQWidget *parent = 0, const char *name = 0 );
        ~Statistics();

        static Statistics *instance() { return s_instance; }

    private slots:
        void    slotSetFilter();
        void    slotSetFilterTimeout();

    private:
        StatisticsList *m_listView;
        ClickLineEdit  *m_lineEdit;
        TQTimer         *m_timer;

        static Statistics *s_instance;
};

class StatisticsList : public TDEListView
{
        Q_OBJECT
  

    public:
        StatisticsList( TQWidget *parent, const char *name=0 );
        ~StatisticsList() {};

        TQString filter()                           { return m_filter; }
        void    setFilter( const TQString &filter ) { m_filter = filter; }
        void    renderView();
        void    refreshView();

    private slots:
        void    clearHover();
        void    itemClicked( TQListViewItem *item );
        void    showContextMenu( TQListViewItem *item, const TQPoint &p, int );
        void    startHover( TQListViewItem *item );

    private:
        void    startDrag();
        void    viewportPaintEvent( TQPaintEvent* );
        void    expandInformation( StatisticsItem *item, bool refresh=false );
        static TQString subText( const TQString &score, const TQString &rating );

        StatisticsItem *m_trackItem;
        StatisticsItem *m_mostplayedItem;
        StatisticsItem *m_artistItem;
        StatisticsItem *m_albumItem;
        StatisticsItem *m_genreItem;
        StatisticsItem *m_newestItem;

        TQListViewItem  *m_currentItem;
        TQString         m_filter;
        bool            m_expanded;
};

/// The listview items which are the headers for the categories
class StatisticsItem : public TQObject, public TDEListViewItem
{
        Q_OBJECT
  

    public:
        StatisticsItem( TQString text, StatisticsList *parent, TDEListViewItem *after=0, const char *name=0 );
        ~StatisticsItem() {};

        void    paintCell( TQPainter *p, const TQColorGroup &cg, int column, int width, int align );
        void    paintFocus( TQPainter*, const TQColorGroup& , const TQRect& ) {};  //reimp
        void    setIcon( const TQString &icon );

        void    enterHover();
        void    leaveHover();

        void       setExpanded( const bool b ) { m_isExpanded = b; }
        const bool isExpanded() { return m_isExpanded; }

        void    setSubtext( TQString t ) { m_subText = t; }

        int     rtti() const { return RTTI; }
        static  const int RTTI = 1000;    //header item

    protected:
        static const int ANIM_INTERVAL = 18;
        static const int ANIM_MAX = 20;

    private slots:
        void slotAnimTimer();

    private:
        TQColor  blendColors( const TQColor& color1, const TQColor& color2, int percent );

        TQTimer *m_animTimer;
        bool    m_animEnter;
        int     m_animCount;

        bool    m_isActive;
        bool    m_isExpanded;

        TQString m_subText;
};

/// Listview items for the children of expanded items (the actual results)
class StatisticsDetailedItem : public TDEListViewItem
{
    public:
        StatisticsDetailedItem( const TQString &text, const TQString &subtext, StatisticsItem *parent,
                                StatisticsDetailedItem *after=0, const char *name=0 );
        ~StatisticsDetailedItem() {};

        enum    ItemType { NONE, TRACK, ARTIST, ALBUM, GENRE, HISTORY };

        void    setup();
        void    paintCell( TQPainter *p, const TQColorGroup &cg, int column, int width, int align );

        void    setItemType( const ItemType t ) { m_type = t; }
        const   ItemType itemType() { return m_type; }

        void    setUrl( TQString &url ) { m_url = url; }
        const   TQString url() { return m_url; }

        void    setSubtext( TQString t ) { m_subText = t; }
        TQString getSQL(); //get the sql query for all the urls the item represents
        KURL::List getURLs();

        void    paintFocus( TQPainter*, const TQColorGroup& , const TQRect& ) {};  //reimp

        int     rtti() const { return RTTI; }
        static  const int RTTI = 1001;    //detailed item

    private:
        ItemType m_type;
        TQString  m_url;
        TQString  m_subText;
};


#endif /* AMAROK_STATISTICS_H */
