/*
  Copyright (c) 2006 Gábor Lehel <illissius@gmail.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef AMAROK_TOOLTIP_H
#define AMAROK_TOOLTIP_H

#include <tqtooltip.h>
#include <tqframe.h>
#include <tqpoint.h>
#include <tqtimer.h>

namespace Amarok
{

class ToolTipClient
{
public:
    virtual TQPair<TQString, TQRect> toolTipText( TQWidget *widget, const TQPoint &pos ) const = 0;
};

class ToolTip: public TQFrame, public TQToolTip
{
    TQ_OBJECT
  

public:
    static void add( ToolTipClient *client, TQWidget *parent );
    static void remove( TQWidget *parent );
    static void hideTips();
    static TQString textFor( TQWidget *widget, const TQPoint &pos = TQPoint() );
    static void updateTip();

private slots:
    void showTip();
    void hideTip();

private:
    ToolTip( ToolTipClient *client, TQWidget *parent );
    virtual ~ToolTip();
    void position();
    ToolTipClient *m_client;
    TQTimer m_timer;
    static TQPoint s_pos;
    static TQRect s_rect;
    static TQString s_text;
    static TQValueList<ToolTip*> s_tooltips;
    class Manager;
    friend class Manager;
    static Manager* s_manager;

public:
    virtual TQSize sizeHint() const;

protected:
    virtual void maybeTip( const TQPoint &pos );
    virtual void drawContents( TQPainter *painter );

public:
    static int s_hack;
};

}

#endif
