/***************************************************************************
 *   Copyright (C) 2005 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef TAGEDIT_H
#define TAGEDIT_H

#include <kdialogbase.h>
#include <kcombobox.h>
#include <tqlistview.h>
#include <tqvaluelist.h>

class TQGroupBox;
class TQLineEdit;
class TQCheckBox;
class KPushButton;
class KKeyButton;
class TDEIconButton;
class TDEFontCombo;
class TQLabel;
class TDEShortcut;

class KColorCombo2;

class FontSizeCombo;

class Tag;
class State;

class StateCopy
{
  public:
	typedef TQValueList<StateCopy*> List;
	StateCopy(State *old = 0);
	~StateCopy();
	State *oldState;
	State *newState;
	void copyBack();
};

class TagCopy
{
  public:
	typedef TQValueList<TagCopy*> List;
	TagCopy(Tag *old = 0);
	~TagCopy();
	Tag *oldTag;
	Tag *newTag;
	StateCopy::List stateCopies;
	void copyBack();
	bool isMultiState();
};

class TagListViewItem : public TQListViewItem
{
  public:
	TagListViewItem(TQListView     *parent, TagCopy *tagCopy);
	TagListViewItem(TQListViewItem *parent, TagCopy *tagCopy);
	TagListViewItem(TQListView     *parent, TQListViewItem *after, TagCopy *tagCopy);
	TagListViewItem(TQListViewItem *parent, TQListViewItem *after, TagCopy *tagCopy);
	TagListViewItem(TQListView     *parent, StateCopy *stateCopy);
	TagListViewItem(TQListViewItem *parent, StateCopy *stateCopy);
	TagListViewItem(TQListView     *parent, TQListViewItem *after, StateCopy *stateCopy);
	TagListViewItem(TQListViewItem *parent, TQListViewItem *after, StateCopy *stateCopy);
	~TagListViewItem();
	TagCopy*   tagCopy()   { return m_tagCopy;   }
	StateCopy* stateCopy() { return m_stateCopy; }
	bool isEmblemObligatory();
	TagListViewItem* lastChild();
	TagListViewItem* prevSibling();
	TagListViewItem* parent() const; // Reimplemented to cast the return value
	int width(const TQFontMetrics &fontMetrics, const TQListView *listView, int column) const;
	void setup();
	void paintCell(TQPainter *painter, const TQColorGroup &colorGroup, int column, int width, int align);

  private:
	TagCopy   *m_tagCopy;
	StateCopy *m_stateCopy;
};

class TagListView : public TQListView
{
  Q_OBJECT
  
  public:
	TagListView(TQWidget *parent = 0, const char *name = 0, WFlags flags = 0);
	~TagListView();
	void keyPressEvent(TQKeyEvent *event);
	void contentsMouseDoubleClickEvent(TQMouseEvent *event);
	void contentsMousePressEvent(TQMouseEvent *event);
	void contentsMouseReleaseEvent(TQMouseEvent *event);
	TagListViewItem* currentItem() const; // Reimplemented to cast the return value
	TagListViewItem* firstChild() const; // Reimplemented to cast the return value
	TagListViewItem* lastItem() const; // Reimplemented to cast the return value
  signals:
	void deletePressed();
	void doubleClickedItem();
};

/**
  * @author S�astien Laot
  */
class TagsEditDialog : public KDialogBase
{
  Q_OBJECT
  
  public:
	TagsEditDialog(TQWidget *parent = 0, State *stateToEdit = 0, bool addNewTag = false);
	~TagsEditDialog();
	State::List deletedStates() { return m_deletedStates; }
	State::List addedStates()   { return m_addedStates;   }
	TagListViewItem* itemForState(State *state);
  private slots:
	void newTag();
	void newState();
	void moveUp();
	void moveDown();
	void deleteTag();
	void renameIt();
	void capturedShortcut(const TDEShortcut &shortcut);
	void removeShortcut();
	void removeEmblem();
	void modified();
	void currentItemChanged(TQListViewItem *item);
	void slotCancel();
	void slotOk();
	void selectUp();
	void selectDown();
	void selectLeft();
	void selectRight();
	void resetTreeSizeHint();
  private:
	void loadBlankState();
	void loadStateFrom(State *state);
	void loadTagFrom(Tag *tag);
	void saveStateTo(State *state);
	void saveTagTo(Tag *tag);
	void ensureCurrentItemVisible();
	TagListView   *m_tags;
	KPushButton   *m_moveUp;
	KPushButton   *m_moveDown;
	KPushButton   *m_deleteTag;
	TQLineEdit     *m_tagName;
	KKeyButton    *m_shortcut;
	TQPushButton   *m_removeShortcut;
	TQCheckBox     *m_inherit;
	TQGroupBox     *m_tagBox;
	TQGroupBox     *m_stateBox;
	TQLabel        *m_stateNameLabel;
	TQLineEdit     *m_stateName;
	TDEIconButton   *m_emblem;
	TQPushButton   *m_removeEmblem;
	TQPushButton   *m_bold;
	TQPushButton   *m_underline;
	TQPushButton   *m_italic;
	TQPushButton   *m_strike;
	KColorCombo2  *m_textColor;
	TDEFontCombo    *m_font;
	FontSizeCombo *m_fontSize;
	KColorCombo2  *m_backgroundColor;
	TQLineEdit     *m_textEquivalent;
	TQCheckBox     *m_onEveryLines;

	TagCopy::List m_tagCopies;
	State::List   m_deletedStates;
	State::List   m_addedStates;

	bool m_loading;
};

#endif // TAGEDIT_H
