/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef DEBUGWINDOW_H
#define DEBUGWINDOW_H

#include <tqwidget.h>

class TQVBoxLayout;
class TQTextBrowser;
class TQString;
class TQCloseEvent;

/**A simple window that display text through debuging messages.
  *@author Sbastien Laot
  */

class DebugWindow : public TQWidget  {
  Q_OBJECT
  
  public:
	/** Construtor and destructor */
	DebugWindow(TQWidget *parent = 0, const char *name = 0);
	~DebugWindow();
	/** Methods to post a message to the debug window */
	void postMessage(const TQString msg);
	DebugWindow& operator<<(const TQString msg);
	void insertHLine();
  protected:
	virtual void closeEvent(TQCloseEvent *event);
  private:
	TQVBoxLayout  *layout;
	TQTextBrowser *textBrowser;
};

#define DEBUG_WIN if (Global::debugWindow) *Global::debugWindow

#endif // DEBUGWINDOW_H
