/***************************************************************************
 *   Copyright (C) 2003 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef SOFTWAREIMPORTERS_H
#define SOFTWAREIMPORTERS_H

#include <tqnamespace.h>
#include <kdialogbase.h>

class TQString;
class TQVButtonGroup;
class TQDomElement;
class KTextEdit;

class Basket;
class Note;

/** The dialog to ask how to import hierarchical data.
  * @author Sébastien Laoût
  */
class TreeImportDialog : public KDialogBase
{
  Q_OBJECT
  
  public:
	TreeImportDialog(TQWidget *parent = 0);
	~TreeImportDialog();
	int choice();
  private:
	TQVButtonGroup *m_choices;
};

/** The dialog to ask how to import text files.
  * @author Sébastien Laoût
  */
class TextFileImportDialog : public KDialogBase
{
  Q_OBJECT
  
  public:
	TextFileImportDialog(TQWidget *parent = 0);
	~TextFileImportDialog();
	TQString separator();
  protected slots:
	void customSeparatorChanged();
  private:
	TQVButtonGroup *m_choices;
	TQRadioButton  *m_anotherSeparator;
	TQTextEdit     *m_customSeparator;
};

/** Functions that import data from other softwares.
  * @author Sébastien Laoût
  */
namespace SoftwareImporters
{
	// Useful methods to design importers:
	TQString fromICS(const TQString &ics);
	TQString fromTomboy(TQString tomboy);
	Note* insertTitledNote(Basket *parent, const TQString &title, const TQString &content, TQt::TextFormat format = TQt::PlainText, Note *parentNote = 0);
	void finishImport(Basket *basket);

	// The importers in themselves:
	void importKNotes();
	void importKJots();
	void importKnowIt();
	void importTuxCards();
	void importStickyNotes();
	void importTomboy();
	void importTextFile();

	//
	void importTuxCardsNode(const TQDomElement &element, Basket *parentBasket, Note *parentNote, int remainingHierarchy);
}

#endif // SOFTWAREIMPORTERS_H
