/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef BASKETSTATUSBAR_H
#define BASKETSTATUSBAR_H

#include <tqobject.h>
#include <tqpixmap.h>

class KStatusBar;
namespace KParts { class StatusBarExtension; }
class TQWidget;
class TQLabel;
class ClickableLabel;

/**
	@author Sébastien Laoût <slaout@linux62.org>
*/
class KDE_EXPORT BasketStatusBar : public TQObject
{
  Q_OBJECT
  
  public:
    BasketStatusBar(KStatusBar *bar);
	BasketStatusBar(KParts::StatusBarExtension *extension);
	~BasketStatusBar();

  public slots:
	/** GUI Main Window actions **/
	void setStatusBarHint(const TQString &hint); /// << Set a specific message or update if hint is empty
	void updateStatusBarHint();                 /// << Display the current state message (dragging, editing) or reset the startsbar message
	void postStatusbarMessage(const TQString &text);
	void setSelectionStatus(const TQString &s);
	void setLockStatus(bool isLocked);
	void setupStatusBar();
	void setUnsavedStatus(bool isUnsaved);

  protected:
	  KStatusBar *statusBar () const;
	  void addWidget(TQWidget * widget, int stretch = 0, bool permanent = false);
	  void setStatusText(const TQString &txt);

  private:
	KStatusBar                 *m_bar;
	KParts::StatusBarExtension *m_extension;
	TQLabel                     *m_selectionStatus;
	ClickableLabel             *m_lockStatus;
	TQLabel                     *m_basketStatus;
	TQLabel                     *m_savedStatus;
	TQPixmap                     m_savedStatusPixmap;
};

#endif
