/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2005-01-04
 * Description : a Digikam image editor plugin for superimpose a 
 *               template to an image.
 *
 * Copyright (C) 2005-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2006-2008 by Marcel Wiesweg <marcel dot wiesweg at gmx dot de>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef SUPERIMPOSEWIDGET_H
#define SUPERIMPOSEWIDGET_H

// TQt includes.

#include <tqwidget.h>
#include <tqimage.h>
#include <tqrect.h>
#include <tqsize.h>
#include <tqpixmap.h>

// KDE includes.

#include <kurl.h>

// Digikam includes.

#include "imageiface.h"
#include "dimg.h"

class TQPixmap;

namespace Digikam
{
class ImageIface;
}

namespace DigikamSuperImposeImagesPlugin
{

enum Action
{
    ZOOMIN=0,
    ZOOMOUT,
    MOVE
};

class SuperImposeWidget : public TQWidget
{
Q_OBJECT
  

public:

    SuperImposeWidget(int w, int h, TQWidget *parent=0);
    ~SuperImposeWidget();

    void   setEditMode(int mode);
    void   resetEdit(void);
    TQRect  getCurrentSelection(void);
    TQSize  getTemplateSize(void);
    Digikam::DImg makeSuperImpose(void);

public slots:

    void slotEditModeChanged(int mode);
    void slotSetCurrentTemplate(const KURL& url);

protected:

    void paintEvent( TQPaintEvent *e );
    void resizeEvent( TQResizeEvent * e );
    void mousePressEvent ( TQMouseEvent * e );
    void mouseReleaseEvent ( TQMouseEvent * e );
    void mouseMoveEvent ( TQMouseEvent * e );

    bool zoomSelection(float deltaZoomFactor);
    void moveSelection(int x, int y);
    void makePixmap(void);
    void setEditModeCursor();

private:

    int            m_w;
    int            m_h;

    int            m_xpos;
    int            m_ypos;
    int            m_editMode;
    float          m_zoomFactor;

    TQPixmap       *m_pixmap;            // For image region selection manipulations.

    TQRect          m_rect;              // For mouse drag position.
    TQRect          m_currentSelection;  // Region selection in image displayed in the widget.
 
    Digikam::DImg  m_template;          // Full template data.
    Digikam::DImg  m_templateScaled;    // Template scaled to preview widget
};

}  // NameSpace DigikamSuperImposeImagesPlugin

#endif /* SUPERIMPOSEWIDGET_H */
