/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-11-17
 * Description : simple image properties side bar (without support 
 *               of digiKam database).
 *
 * Copyright (C) 2004-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqrect.h>
#include <tqsplitter.h>

// KDE includes.

#include <tdelocale.h>
#include <tdeconfig.h>
#include <tdeapplication.h>
#include <kcursor.h>
#include <tdeglobal.h>
#include <kiconloader.h>

// Local includes.

#include "ddebug.h"
#include "dimg.h"
#include "imagepropertiestab.h"
#include "imagepropertiesmetadatatab.h"
#include "imagepropertiescolorstab.h"
#include "imagepropertiessidebar.h"
#include "imagepropertiessidebar.moc"

namespace Digikam
{

ImagePropertiesSideBar::ImagePropertiesSideBar(TQWidget *parent, const char *name, 
                                               TQSplitter *splitter, Side side, 
                                               bool mimimizedDefault, bool navBar)
                      : Sidebar(parent, name, side, mimimizedDefault)
{
    m_image              = 0;
    m_currentRect        = TQRect();
    m_dirtyPropertiesTab = false;
    m_dirtyMetadataTab   = false;
    m_dirtyColorTab      = false;
    
    m_propertiesTab = new ImagePropertiesTab(parent, navBar);
    m_metadataTab   = new ImagePropertiesMetaDataTab(parent, navBar);
    m_colorTab      = new ImagePropertiesColorsTab(parent, navBar);
    
    setSplitter(splitter);
         
    appendTab(m_propertiesTab, SmallIcon("application-vnd.tde.info"), i18n("Properties"));
    appendTab(m_metadataTab, SmallIcon("exifinfo"), i18n("Metadata"));
    appendTab(m_colorTab, SmallIcon("blend"), i18n("Colors"));
    
    connect(this, TQT_SIGNAL(signalChangedTab(TQWidget*)),
            this, TQT_SLOT(slotChangedTab(TQWidget*)));
}

ImagePropertiesSideBar::~ImagePropertiesSideBar()
{
}

void ImagePropertiesSideBar::itemChanged(const KURL& url, const TQRect &rect, DImg *img)
{
    if (!url.isValid())
        return;

    m_currentURL         = url;
    m_currentRect        = rect;
    m_image              = img;
    m_dirtyPropertiesTab = false;
    m_dirtyMetadataTab   = false;
    m_dirtyColorTab      = false;

    slotChangedTab( getActiveTab() );
}

void ImagePropertiesSideBar::slotNoCurrentItem(void)
{
    m_currentURL = KURL();

    m_propertiesTab->setCurrentURL();
    m_propertiesTab->setNavigateBarFileName();

    m_metadataTab->setCurrentURL();
    m_metadataTab->setNavigateBarFileName();

    m_colorTab->setData();
    m_colorTab->setNavigateBarFileName();

    m_dirtyPropertiesTab = false;
    m_dirtyMetadataTab   = false;
    m_dirtyColorTab      = false;
}

void ImagePropertiesSideBar::slotImageSelectionChanged(const TQRect &rect)
{
    m_currentRect = rect;

    if (m_dirtyColorTab)
       m_colorTab->setSelection(rect);
    else
       slotChangedTab(m_colorTab);
}

void ImagePropertiesSideBar::slotChangedTab(TQWidget* tab)
{
    if (!m_currentURL.isValid())
        return;
    
    setCursor(KCursor::waitCursor());
    
    if (tab == m_propertiesTab && !m_dirtyPropertiesTab)
    {
       m_propertiesTab->setCurrentURL(m_currentURL);
       m_dirtyPropertiesTab = true;
    }
    else if (tab == m_metadataTab && !m_dirtyMetadataTab)
    {
       m_metadataTab->setCurrentURL(m_currentURL);
       m_dirtyMetadataTab = true;
    }
    else if (tab == m_colorTab && !m_dirtyColorTab)
    {
       m_colorTab->setData(m_currentURL, m_currentRect, m_image);
       m_dirtyColorTab = true;
    }
    
    unsetCursor();
}

}  // NameSpace Digikam
