/*
 * kevents.h
 *
 * Copyright (C) 2004-2007 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef KEVENTS_H
#define KEVENTS_H

#include <tqtimer.h>
#include <tqdialog.h>
#include <tqdatetime.h>
#include <tqtextbrowser.h>

#include <tdelistview.h>
#include <kpushbutton.h>
#include <klineedit.h>

class EventDesc;
class DvbStream;
class EventTable;
class ChannelDesc;


class EListViewItem : public TDEListViewItem
{

public:

	EListViewItem( TQListView *parent, TQString chanName, TQString eBegin, TQString eDuration, TQString eTitle, EventDesc *desc );
	virtual int compare( TQListViewItem *i, int col, bool ascending ) const;

	EventDesc *event;
};



class KEvents : public TQDialog
{
	Q_OBJECT
  

public:

	KEvents( TQPtrList<ChannelDesc> *chans, TQPtrList<DvbStream> *d, EventTable *t, TQWidget *parent, TQSize size );
	~KEvents();

private slots:

	void mouseClickedSlot( int btn, TQListViewItem *it, const TQPoint &p, int c );
	void reset();
	void setMode( int m, TQString name="" );
	void setScheduled();
	void setCurrentNext();
	void setCurrentChannelEpg();
	void epgSearch();
	void resetSearch();
	void zap( TQListViewItem* it, const TQPoint &p, int col );

private:
	void checkEpgSearch(TQString searchword);
	void checkNewEvent();

	TQPtrList<DvbStream> *dvb;
	EventTable *events;
	TDEListView *listView;
	KPushButton *resetBtn, *currentNextBtn, *allBtn, *currentChannelEpgBtn;
	TQToolButton *searchBtn;
	TQCheckBox *titleCb,*tvradioCb,*ftaCb;
	TQPtrList<ChannelDesc> *channels;
	TQTextBrowser *textBrow;
	int mode;
	ChannelDesc *chan;

protected:

	KLineEdit *searchLineEdit;

signals:

	void addTimer( TQString channel, TQString name, TQDateTime begin, TQTime duration );
	void zapTo( const TQString &channel );
};

#endif /* KEVENTS_H */
