#ifndef __CONTROLS_H
#define __CONTROLS_H

#include <tqguardedptr.h>

#include <tdeaction.h>
#include <tdetoolbar.h>
#include <tqslider.h>
#include <tqstringlist.h>
#include <kdemacros.h>

class TQComboBox;
class TQLabel;

/**
 * A slider that can be moved around while being
 * changed internally
 *
 * @short Special TQSlider based class suitable for time sliders
 * @author Charles Samuels
 * @version 2.3
 **/
class KDE_EXPORT L33tSlider : public TQSlider
{
Q_OBJECT
  
public:
	L33tSlider(TQWidget * parent, const char * name=0);
	L33tSlider(Qt::Orientation, TQWidget * parent, const char * name=0);
	L33tSlider(int minValue, int maxValue, int pageStep, int value,
	           Qt::Orientation, TQWidget * parent, const char * name=0);

	bool currentlyPressed() const;
signals:
	/**
	 * emmited only when the user changes the value by hand
	 **/
	void userChanged(int value);

public slots:
	virtual void setValue(int);

protected:
	virtual void mousePressEvent(TQMouseEvent*);
	virtual void mouseReleaseEvent(TQMouseEvent*);
	virtual void wheelEvent(TQWheelEvent *);

private:
	bool pressed;
};

/**
 * @short A slider for your toolbar
 * @author Charles Samuels
 * @version 2.3
 **/
class SliderAction : public TDEAction
{
Q_OBJECT
  
public:
	SliderAction(const TQString& text, int accel, const TQObject *receiver,
	             const char *member, TQObject* parent, const char* name );
	virtual int plug( TQWidget *w, int index = -1 );
	virtual void unplug( TQWidget *w );
	TQSlider* slider() const { return m_slider; }

signals:
	void plugged();

public slots:
	void toolbarMoved(TDEToolBar::BarPosition pos);

private:
	TQGuardedPtr<TQSlider> m_slider;
	TQStringList m_items;
	const TQObject *m_receiver;
	const char *m_member;
};

#endif
