#ifndef __KMIX_IFACE_H
#define __KMIX_IFACE_H

#include <dcopobject.h>

/**
  Provides a subset of MixerIface DCOP interface tailored to specifically
  act onto the current device/channel selected by the user as main channel
*/

class KMixIface : virtual public DCOPObject
{
   K_DCOP

k_dcop:
   /**
    Sets the volume to the percentage specified in the parameter.
    */
   virtual void setVolume(int percentage)=0;
   /**
    Increase the volume by the percentage specified in the parameter.
    */
   virtual void increaseVolume(int percentage)=0;
   /**
    Decrease the volume by the percentage specified in the parameter.
    */
   virtual void decreaseVolume(int percentage)=0;
   /**
    Returns the volume of the device (as a percentage, 0..100).
    */
   virtual int volume()=0;

   /**
    Sets the absolute volume of the device. Lower bound is absoluteVolumeMin(),
    upper bound is absoluteVolumeMax().
    */
   virtual void setAbsoluteVolume(long absoluteVolume)=0;
   /**
    Returns the absolute volume of the device. The volume is in the range of
    absoluteVolumeMin() <= absoluteVolume() <= absoluteVolumeMax()
    */
   virtual long absoluteVolume()=0;
   /**
    Returns the absolute maximum volume of the device.
    */
   virtual long absoluteVolumeMin()=0;
   /**
    Returns the absolute minimum volume of the device.
    */
   virtual long absoluteVolumeMax()=0;

   /**
    Mutes or unmutes the specified device.
    */
   virtual void setMute(bool on)=0;
   /**
    Toggles mute-state for the given device.
    */
   virtual void toggleMute()=0;
   /**
    Returns if the given device is muted or not. If no device is
    available, it is reported as muted.
    */
   virtual bool mute()=0;

   /**
    Returns the name of the mixer.
    */
   virtual TQString mixerName()=0;
   /**
    Returns the index of the master device
    */
   virtual int deviceIndex()=0;

   /**
    Sets the balance of the device (negative means balanced to the left
    speaker and positive to the right one)
    */
   virtual void setBalance(int balance)=0;
};

#endif
