#ifndef PLUGIN_LOADER_H
#define PLUGIN_LOADER_H

#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>
#include <noatun/app.h>

#include <klibloader.h>
#include <tqdict.h>
#include <kdemacros.h>

struct NoatunLibraryInfo
{
	TQString specfile;
	TQString filename;
	TQString author;
	TQString license;
	TQString type;
	TQString site;
	TQString email;
	TQString name;
	TQString comment;
	TQStringList require;
};

bool operator ==(const NoatunLibraryInfo &, const NoatunLibraryInfo &);

class Playlist;
class Visualization;
class Plugin;

/**
 * Used for loading plugins at runtime
 **/
class KDE_EXPORT LibraryLoader
{
	friend class Plugin;
	struct PluginLibrary
	{
		Plugin *plugin;
		KLibrary *library;
	};

public:
	LibraryLoader();
	~LibraryLoader();

	TQValueList<NoatunLibraryInfo> available() const;
	TQValueList<NoatunLibraryInfo> loaded() const;
	TQValueList<NoatunLibraryInfo> loadedByType(const TQString &type) const;

	/**
	 * loads all the enabled plugins
	 **/
	bool loadAll(void);
	bool loadAll(const TQStringList &);

	bool isLoaded(const TQString &spec) const;
	void add(const TQString &spec);
	void setModules(const TQStringList &mods);
	/**
	 * unload the plugin specified by spec
	 **/
	bool remove(const TQString &spec);
	/**
	 * Same as the above, but does not call kapp->exit() even
	 * when the last userinterface plugin is removed. Necessary
	 * during session management (see marquis plugin).
	 * ### BIC: merge with above with terminateOnLastUI = true
	 */
	bool remove(const TQString &spec, bool terminateOnLastUI);
	/**
	 * unload the plugin that is referenced by @par plugin
	 **/
	bool remove(const LibraryLoader::PluginLibrary *plugin);
	bool remove(const Plugin *plugin);

	Playlist *playlist() const;

	/**
	 * This is needed for the Plugin-List-View
	 * to see what plugins are required to show
	 * (when required by another noatun-plugin)
	 **/
	NoatunLibraryInfo getInfo(const TQString &spec) const;
	TQPtrList<Plugin> plugins() const;

private:
	bool loadSO(const TQString &spec);
	void removeNow(const TQString &spec);

private:
	TQDict<LibraryLoader::PluginLibrary> mLibHash;
	Playlist *mPlaylist;
};

#endif

