#ifndef EDITOR_H
#define EDITOR_H

#include <kdialogbase.h>
#include <noatun/playlist.h>
#include <tqptrlist.h>
#include <tqvariant.h>

class KFileMetaInfo;
class KFileMetaInfoItem;
class TQGridLayout;

struct MetaWidget {
    TQWidget *widget;
    TQString key;
};

class Editor:public KDialogBase {
    TQ_OBJECT
  
  public:
    Editor();

  signals:
    void saved(PlaylistItem &);

  public slots:
    void open(const PlaylistItem & i);

  protected slots:
    void save();
    void modified();

  protected:
    bool keyAddable(const KFileMetaInfo &, TQString);
    TQString keyGroup(const KFileMetaInfo &, TQString);

    void saveControl(KFileMetaInfo& meta_info, const MetaWidget&);
    MetaWidget *createControl(KFileMetaInfo& meta_info, const TQString &label, const TQString &key, TQVariant::Type default_type, bool optional, TQWidget *parent);

    TQPtrList<MetaWidget> mControls;

    TQWidget *mMainWidget;
    TQGridLayout *mGrid;
    int mNextRow;

    bool mFileWritable;
    bool mDirty;

    TQLabel *mFile;
    TQLabel *mFileIcon;
    const char *filename;
    PlaylistItem item;
};

#endif
