#ifndef DIALOGSELECTMASTER_H
#define DIALOGSELECTMASTER_H

class TQButtonGroup;
#include <tqradiobutton.h>
class TQScrollView;
#include <tqstringlist.h>
class TQVBox;
class TQVBoxLayout;

class KComboBox;
#include <kdialogbase.h>

class Mixer;

class DialogSelectMaster : public KDialogBase
{
    TQ_OBJECT
  
 public:
    DialogSelectMaster(Mixer *mixer);
    ~DialogSelectMaster();
    void show(Mixer *curr_mixer);

 signals:
    void newMasterSelected(bool defaultMaster, int soundcard_id, const TQString &channel_id);

 public slots:
    void apply();

 private:
    void createWidgets(Mixer*);
    void createPage(Mixer*);
    TQVBoxLayout* _layout;
    KComboBox* m_cMixer;
    TQScrollView* m_scrollableChannelSelector;
    TQVBox *m_vboxChannels, *m_vboxForScrollView;
    TQButtonGroup *m_buttonGroupForScrollView;
    TQRadioButton *m_defaultMaster, *m_userMaster;
    TQStringList m_mixerPKs;

 private slots:
   void masterSelectionChanged(int _unused);
   void createPageByID(int mixerId);
};

#endif
