#include <tqpushbutton.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <kdialogbase.h>

#include <tdeapplication.h>
#include <tdelocale.h>

#include "channelview.h"
#include "channelcfgdlg.h"
#include "version.h"
#include <tqlayout.h>
#include <tqvbuttongroup.h>

ChannelViewConfigDialog::ChannelViewConfigDialog(TQWidget *parent,const char *name) : KDialogBase(parent,name,TRUE,i18n("Configure Channel View"),Ok|Cancel, Ok)
{
    TQWidget *page = new TQWidget( this );
    setMainWidget(page);
    TQVBoxLayout *topLayout = new TQVBoxLayout( page, 0, spacingHint() );
    qbg = new TQVButtonGroup(i18n("Choose Look Mode"),page,"qbg");
    
    rb0=new TQRadioButton(i18n("3D look"),qbg,"3d");
    rb1=new TQRadioButton(i18n("3D - filled"),qbg,"4d");

    qbg->setExclusive(TRUE);

    topLayout->addWidget( qbg );
    ((ChannelView::lookMode()==0)?rb0:rb1)->setChecked(TRUE);
    
    connect (qbg, TQ_SIGNAL(pressed(int)),this,TQ_SLOT(modeselected(int)));
}

void ChannelViewConfigDialog::modeselected(int idx)
{
selectedmode=idx;
}

int ChannelViewConfigDialog::selectedmode;
#include "channelcfgdlg.moc"
