/**
 * This file is part of the KAudioCreator package
 * Copyright (C) 2003 Benjamin C Meyer (ben+kaudiocreator at meyerhome dot net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef ENCODERCONFIGIMP_H
#define ENCODERCONFIGIMP_H

#include "encoderconfig.h"
#include "encoder_prefs.h"
#include <tqmap.h>
#include <tqdict.h>

/**
 * Class mainly build to manage encoder list.
 */
class EncoderConfigImp : public EncoderConfig {

TQ_OBJECT
  

signals:
  void encoderUpdated();

public:
  EncoderConfigImp( TQWidget* parent = 0, const char* name = 0);

private slots:
  void addEncoderSlot();
  void removeEncoderSlot();
  void configureEncoderSlot();

  void updateEncoder(TQObject * obj);
  void updateEncoder(const char *dialogName);
  void loadEncoderList();

private:
  // Name, groupName
  TQMap<TQString, TQString> encoderNames;
};

#endif

