#ifndef WAREGION_H
#define WAREGION_H

#include <tqcolor.h>
#include <tqstring.h>

class WaRegion {
public:
    WaRegion(TQString filename);
    ~WaRegion();

    const TQBitmap *mainWindowMask() const { return window_mask; }
    const TQBitmap *mainWindowShadeMask() const { return shade_mask; }

private:
   TQValueList<int> parseList(const TQString &list) const;
   void buildPixmap(const TQValueList<int> &num_points, const TQValueList<int> &point_list, TQBitmap *dest);

   TQBitmap *window_mask;
   TQBitmap *shade_mask;
};

extern WaRegion *windowRegion;

#endif

