/***************************************************************************
*                               docking.cpp
*                             -------------------
*
*    Revision     : $Id$
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*                 : Based On Caitoo v.0.7.3 (c) 1998 - 2000, Matej Koss
*    email        : pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/

#include <tqtooltip.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdepopupmenu.h>
#include <kurldrag.h>

#include "tdemainwidget.h"
#include "settings.h"
#include "docking.h"


DockWidget::DockWidget(TDEMainWidget * _parent):KSystemTray(_parent)
{
    parent = _parent;

    setPixmap( loadIcon( "kget_dock" ));

    // popup menu for right mouse button
    TDEPopupMenu *popupMenu = contextMenu();
    parent->action("paste_transfer")->plug(popupMenu);
    parent->action("drop_target")->plug(popupMenu);
    parent->action("konqueror_integration")->plug(popupMenu);
    popupMenu->insertSeparator();
    parent->m_paPreferences->plug(popupMenu);

    // Enable dropping
    setAcceptDrops(true);
   
    dtip = new DynamicTip( this );
    dtip->setStatus( kapp->aboutData()->shortDescription() );

}


DockWidget::~DockWidget()
{
   delete dtip;
   dtip = 0;
}


void DockWidget::dragEnterEvent(TQDragEnterEvent * event)
{
    event->accept(KURLDrag::canDecode(event)
                  || TQTextDrag::canDecode(event));
}


void DockWidget::dropEvent(TQDropEvent * event)
{
    KURL::List list;
    TQString str;

    if (KURLDrag::decode(event, list)) {
        parent->addTransfers(list);
    } else if (TQTextDrag::decode(event, str)) {
        parent->addTransfer(str);
    }
}


void DockWidget::mousePressEvent(TQMouseEvent * e)
{
    if (e->button() == Qt::MidButton) {
        parent->slotPasteTransfer();
    } else {
        KSystemTray::mousePressEvent(e);
    }
}


void DockWidget::updateToolTip( const TQString& _status )
{
   dtip->setStatus( _status );
}


void DockWidget::changeIcon( const TQString& icon )
{
    setPixmap( loadIcon( icon ));
}


DynamicTip::DynamicTip( TQWidget * parent )
   : TQToolTip( parent )
{
   // no explicit initialization needed
}


void DynamicTip::setStatus( const TQString & _status )
{
   status = _status;
}

void DynamicTip::maybeTip( const TQPoint & _pos )
{
   TQRect r( parentWidget()->rect() );
   tip( r, status );
}

#include "docking.moc"
