/*
    kopetecontactaction.cpp - TDEAction for selecting a Kopete::Contact

    Copyright (c) 2003 by Martijn Klingens       <klingens@kde.org>

    Kopete    (c) 2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "kopetecontactaction.h"

#include "kopetemetacontact.h"
#include "kopetecontact.h"
#include "kopeteonlinestatus.h"

KopeteContactAction::KopeteContactAction( Kopete::Contact *contact, const TQObject *receiver,
	const char *slot, TDEAction *parent )
: TDEAction( contact->metaContact()->displayName(), TQIconSet( contact->onlineStatus().iconFor( contact ) ), TDEShortcut(),
	parent, contact->contactId().latin1() )
{
	m_contact = contact;

	connect( this, TQT_SIGNAL( activated() ), TQT_SLOT( slotContactActionActivated() ) );
	connect( this, TQT_SIGNAL( activated( Kopete::Contact * ) ), receiver, slot );
}

KopeteContactAction::~KopeteContactAction()
{
}

void KopeteContactAction::slotContactActionActivated()
{
	emit activated( m_contact );
}

Kopete::Contact * KopeteContactAction::contact() const
{
	return m_contact;
}


#include "kopetecontactaction.moc"
