/***************************************************************************
                          Netmeetingpreferences.cpp  -  description
                             -------------------
    copyright            : (C) 2004 by Olivier Goffart
    email                : ogoffart @ kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqlayout.h>
#include <tqcheckbox.h>

#include <kcombobox.h>
#include <klineedit.h>
#include <tdeparts/componentfactory.h>
#include <tdelocale.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <kcombobox.h>
#include <tdelistview.h>
#include <kgenericfactory.h>
#include <kcolorbutton.h>
#include <kinputdialog.h>
#include <kurlrequester.h>
#include <kregexpeditorinterface.h>
#include <kdebug.h>

#include "netmeetingplugin.h"
#include "netmeetingprefs_ui.h"
#include "netmeetingpreferences.h"

typedef KGenericFactory<NetmeetingPreferences> NetmeetingPreferencesFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kopete_netmeeting, NetmeetingPreferencesFactory( "kcm_kopete_netmeeting" )  )

NetmeetingPreferences::NetmeetingPreferences(TQWidget *parent, const char* /*name*/, const TQStringList &args)
							: TDECModule(NetmeetingPreferencesFactory::instance(), parent, args)
{
	( new TQVBoxLayout( this ) )->setAutoAdd( true );
	preferencesDialog = new NetmeetingPrefsUI(this);

	connect(preferencesDialog->m_app , TQT_SIGNAL(textChanged(const TQString &)) , this , TQT_SLOT(slotChanged()));

	load();
}

NetmeetingPreferences::~NetmeetingPreferences()
{
}

void NetmeetingPreferences::load()
{
	TDEConfig *config=TDEGlobal::config();
	config->setGroup("Netmeeting Plugin");
	preferencesDialog->m_app->setCurrentText(config->readEntry("NetmeetingApplication","ekiga -c callto://%1"));
	emit TDECModule::changed(false);
}

void NetmeetingPreferences::save()
{
	TDEConfig *config=TDEGlobal::config();
	config->setGroup("Netmeeting Plugin");
	config->writeEntry("NetmeetingApplication",preferencesDialog->m_app->currentText());
	emit TDECModule::changed(false);
}


void NetmeetingPreferences::slotChanged()
{
	emit TDECModule::changed(true);
}

#include "netmeetingpreferences.moc"
