/* -------------------------------------------------------------

   matchview.h (part of The KDE Dictionary Client)

   Copyright (C) 2000-2001 Christian Gebauer <gebauer@kde.org>

   This file is distributed under the Artistic License.
   See LICENSE for details.

   -------------------------------------------------------------

   MatchView  This widget contains the list of matching definitions

 ------------------------------------------------------------- */


#ifndef _MATCHVIEW_H_
#define _MATCHVIEW_H_

#include <tqlistview.h>
class TDEPopupMenu;


//*********  MatchViewItem  ********************************************

class MatchViewItem : public TQListViewItem
{
  
public:
                
  MatchViewItem(TQListView *view,const TQString &text);
  MatchViewItem(TQListView *view,TQListViewItem *after,const TQString &text);
  MatchViewItem(TQListViewItem *item,const TQString &text,const TQString &commandStr);
  MatchViewItem(TQListViewItem *item,TQListViewItem *after,const TQString &text,const TQString &commandStr);
  ~MatchViewItem();

  void setOpen(bool o);
  void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment);

  TQString command;
  TQStringList subEntrys;
};


//*********  MatchView  ******************************************


class MatchView : public TQWidget
{
  TQ_OBJECT
  

public:

  MatchView(TQWidget *parent=0,const char *name=0);
  ~MatchView();

  void updateStrategyCombo();
  bool selectStrategy(const TQString &strategy) const;
  void match(const TQString &query);

signals:

  void defineRequested(const TQString &query);
  void matchRequested(const TQString &query);
  void clipboardRequested();
  void windowClosed();

protected:

  void closeEvent ( TQCloseEvent * e );

private slots:

  void strategySelected(int num);
  void enableGetButton();
  void mouseButtonPressed(int, TQListViewItem *, const TQPoint &, int);
  void returnPressed(TQListViewItem *i);
  void getOneItem(TQListViewItem *i);
  void getSelected();
  void getAll();
  void doGet(TQStringList &defines);
  void newList(const TQStringList &matches);
  void buildPopupMenu(TQListViewItem *, const TQPoint &, int);
  void popupGetCurrent();
  void popupDefineCurrent();
  void popupMatchCurrent();
  void popupDefineClip();
  void popupMatchClip();
  void expandList();
  void collapseList();

private:

  TQComboBox *w_strat;
  TQListView *w_list;
  TQPushButton *w_get,*w_getAll;

  bool getOn, getAllOn;

  TDEPopupMenu *rightBtnMenu;
  MatchViewItem *popupCurrent;
  TQString popupClip;   // needed for rightbtn-popup menu
};

#endif
