/*
    tdeconf_update app for updating the contactlist format ( <= 0.9.0) for MetaContacts to
    track the name of a subcontact.

    Kopete    (c) 2002-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include <tqdir.h>
#include <tqtextstream.h>
#include <tqdom.h>

#include <kstandarddirs.h>

static TQTextStream qcerr( stderr, IO_WriteOnly );

int main()
{
	TDEInstance* inst = new TDEInstance( "Update script" );
	TQString filename = locateLocal( "data", TQString::fromLatin1( "kopete/contactlist.xml" ) );
	
	// Load contact list & save backup.
	TQFile contactListFile( filename );
	contactListFile.open( IO_ReadOnly );
	TQDomDocument contactList;
	contactList.setContent( &contactListFile );
	contactListFile.close();
	TQDir().rename( filename, filename + TQString::fromLatin1( ".bak" ) );
	
	// parse the XML file
	TQDomElement list = contactList.documentElement();
	TQDomElement mcElement = list.firstChild().toElement();
	
	while( !mcElement.isNull() )
	{
		
		// update all the MetaContacts
		if( mcElement.tagName() == TQString::fromLatin1("meta-contact") )
		{
			TQDomElement displayName;
			TQDomElement subcontact;
			
			TQDomElement elem = mcElement.firstChild().toElement();
			while( !elem.isNull() )
			{
				if( elem.tagName() == TQString::fromLatin1( "display-name" ) )
					displayName = elem;
				if( elem.tagName() == TQString::fromLatin1( "plugin-data" ) )
				{
					// check if it's a contact by checking for "protocol" substring in the tag,
					// and the presence of a contactId child element.
					TQString pluginId = elem.attribute( TQString::fromLatin1( "plugin-id" ) );
					bool isProtocol = ( pluginId.contains( "protocol", false ) > 0 ); // case-insensitive search
					bool hasContactId = false;
					TQDomNode field = elem.firstChild();
					while( !field.isNull() )
					{
						TQDomElement fieldElem = field.toElement();
						
						if( !fieldElem.isNull() &&
							fieldElem.tagName() == TQString::fromLatin1( "plugin-data-field" ) && 
							fieldElem.attribute( TQString::fromLatin1( "key" ) ) == TQString::fromLatin1( "contactId" ) )
						{
							hasContactId = true;
							break;
						}
						field = field.nextSibling();
					}
					
					if( isProtocol && hasContactId )
						subcontact = elem;
				}
				
				elem = elem.nextSibling().toElement();
			} // end while
			
			// check if we're even tracking the subcontact's name
			// if displayName.isNull(), it simply won't find the attribute; no harm done
			bool tracking = 
				( displayName.attribute( TQString::fromLatin1( "trackChildNameChanges" ),
				TQString::fromLatin1( "0" ) ) == TQString::fromLatin1( "1" ) );
			if( !displayName.isNull() && !subcontact.isNull() && tracking )
			{
				// collect info
				TQString nsCID;
				TQString nsPID;
				TQString nsAID;

				nsPID = subcontact.attribute( TQString::fromLatin1( "plugin-id" ) );
				TQDomNode field = subcontact.firstChild();
				while( !field.isNull() )
				{
					TQDomElement fieldElem = field.toElement();
						
					if( !fieldElem.isNull() && fieldElem.tagName() == TQString::fromLatin1( "plugin-data-field" ) )
					{
						 if( fieldElem.attribute( TQString::fromLatin1( "key" ) ) == TQString::fromLatin1( "contactId" ) )
							 nsCID = fieldElem.text();
						 if( fieldElem.attribute( TQString::fromLatin1( "key" ) ) == TQString::fromLatin1( "accountId" ) )
							 nsAID = fieldElem.text();
					}
					field = field.nextSibling();
				}
				
				// create the tracking info
				displayName.setAttribute( TQString::fromLatin1( "nameSourceContactId" ), nsCID );
				displayName.setAttribute( TQString::fromLatin1( "nameSourcePluginId" ), nsPID );
				displayName.setAttribute( TQString::fromLatin1( "nameSourceAccountId" ), nsAID );
			}
		}	
		
		mcElement = mcElement.nextSibling().toElement();
	}

	// Save converted contactlist
	contactListFile.open( IO_WriteOnly );
	TQTextStream stream( &contactListFile );
	stream.setEncoding( TQTextStream::UnicodeUTF8 );
	stream << contactList.toString( 4 );
	contactListFile.flush();
	contactListFile.close();

	return 0;
}
