/*
	Kopete Oscar Protocol
	icquserinfo.h - ICQ User Info Data Types
	
	Copyright (c) 2004 Matt Rogers <mattr@kde.org>
	
	Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>
	
	*************************************************************************
	*                                                                       *
	* This library is free software; you can redistribute it and/or         *
	* modify it under the terms of the GNU Lesser General Public            *
	* License as published by the Free Software Foundation; either          *
	* version 2 of the License, or (at your option) any later version.      *
	*                                                                       *
	*************************************************************************
*/

#ifndef _ICQUSERINFO_H_
#define _ICQUSERINFO_H_

#include <tqcstring.h>
#include <tqvaluelist.h>
#include <tqdatetime.h>
#include "kopete_export.h"

class Buffer;

/**
 * @file icquserinfo.h
 * Classes encapsulating user data retrieved from the server
 */

class KOPETE_EXPORT ICQInfoBase
{
public:
	
	ICQInfoBase() : m_sequence( 0 ) {}
	virtual ~ICQInfoBase() {}
	virtual void fill( Buffer* buffer ) = 0;
	
	void setSequenceNumber( int number ) { m_sequence = number; }
	int sequenceNumber() { return m_sequence; }

private:
	int m_sequence;
};


class KOPETE_EXPORT ICQShortInfo : public ICQInfoBase
{
public:
	ICQShortInfo();
	~ICQShortInfo() {}
	void fill( Buffer* buffer );
	
public:
	unsigned long uin;
	TQCString nickname;
	TQCString firstName;
	TQCString lastName;
	TQCString email;
	bool needsAuth;
	unsigned int gender; // 0=offline, 1=online, 2=not webaware
};

class KOPETE_EXPORT ICQGeneralUserInfo : public ICQInfoBase
{
public:
	ICQGeneralUserInfo();
	~ICQGeneralUserInfo() {}
	void fill( Buffer* buffer );
	
public:
	unsigned long uin;
	TQCString nickname;
	TQCString firstName;
	TQCString lastName;
	TQCString email;
	TQCString city;
	TQCString state;
	TQCString phoneNumber;
	TQCString faxNumber;
	TQCString address;
	TQCString cellNumber;
	TQCString zip;
	int country;
	char timezone;
	bool publishEmail;
	bool allowsDC;
	bool webaware;
};

class KOPETE_EXPORT ICQWorkUserInfo : public ICQInfoBase
{
public:
	ICQWorkUserInfo();
	~ICQWorkUserInfo() {}
	void fill( Buffer* buffer );
	
public:
	TQCString city;
	TQCString state;
	TQCString phone;
	TQCString fax;
	TQCString address;
	TQCString zip;
	int country;
	TQCString company;
	TQCString department;
	TQCString position;
	int occupation;
	TQCString homepage;
};

class KOPETE_EXPORT ICQMoreUserInfo : public ICQInfoBase
{
public:
	ICQMoreUserInfo();
	~ICQMoreUserInfo() {}
	void fill( Buffer* buffer );
	
public:
	int age;
	unsigned int gender;
	TQCString homepage;
	TQDate birthday;
	unsigned int lang1;
	unsigned int lang2;
	unsigned int lang3;
	TQCString ocity;
	TQCString ostate;
	int ocountry;
	int marital;
};

class KOPETE_EXPORT ICQEmailInfo : public ICQInfoBase
{
public:
	ICQEmailInfo();
	~ICQEmailInfo() {}
	void fill( Buffer* buffer );
	
public:
	TQValueList<TQCString> emailList;
};

class KOPETE_EXPORT ICQInterestInfo : public ICQInfoBase
{
public:
	ICQInterestInfo();
	~ICQInterestInfo() {}
	void fill( Buffer* buffer );
	
public:
	int count;
	int topics[4];
	TQCString descriptions[4];
};


class KOPETE_EXPORT ICQSearchResult
{
public:
	ICQSearchResult();
	void fill( Buffer* buffer );
	TQ_UINT32 uin;
	TQCString firstName;
	TQCString lastName;
	TQCString nickName;
	TQCString email;
	bool auth;
	bool online;
	char gender;
	TQ_UINT16 age;
};

class KOPETE_EXPORT ICQWPSearchInfo
{
public:
	ICQWPSearchInfo();
	
	TQCString firstName;
	TQCString lastName;
	TQCString nickName;
	TQCString email;
	int age;
	int gender;
	int language;
	TQCString city;
	TQCString state;
	int country;
	TQCString company;
	TQCString department;
	TQCString position;
	int occupation;
	bool onlineOnly;
};

/*
class ICQInfoItem
{
public:
	int category;
	TQCString description;
};


typedef TQValueList<ICQInfoItem> ICQInfoItemList;
*/

#endif
