/*
    yahoobuddyiconloader.h - Fetches YahooBuddyIcons

    Copyright (c) 2005 by André Duffeck <duffeck@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef YAHOOBUDDYICONLOADER_
#define	YAHOOBUDDYICONLOADER_

// QT Includes
#include <tqobject.h>
#include <tqstring.h>
#include <tqmap.h>

// KDE Includes
#include <kurl.h>

class KJob;
class Client;
namespace TDEIO {
	class Job;
	class TransferJob;
}

struct IconLoadJob {
	KURL url;
	TQString who;
	int checksum;
	TQByteArray icon;
};

/**
 * @author André Duffeck
 *
 * This class handles the download of a Buddy icon.
 * If the download was succesfull it emits a signal with a pointer
 * to the temporary file, the icon was stored at
 */
class YahooBuddyIconLoader : public TQObject
{
	TQ_OBJECT
  
public:
	YahooBuddyIconLoader( Client *c );
	~YahooBuddyIconLoader();

	/**
	 *	Add a BuddyIcon for download.
	 */
	void fetchBuddyIcon( const TQString &who, KURL url, int checksum );

signals:
	/**
	 * 	The account can connect to this signal and append the icon
	 * 	stored in 'file' to the appropriate contact
	 */
	void fetchedBuddyIcon( const TQString &who, const TQByteArray &icon, int checksum );

private slots:
	void slotData( TDEIO::Job *job, const TQByteArray &data );
	void slotComplete( TDEIO::Job *job );

private:
	typedef TQMap< TDEIO::TransferJob *, IconLoadJob > TransferJobMap;
	TransferJobMap m_jobs;
	Client *m_client;
};

#endif
