/*
 * forwmachpage.cpp - Forwarding machine settings for KTalkd
 *
 * Copyright (C) 1998 David Faure, faure@kde.org
 *
 * Requires the TQt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "forwmachpage.h"

#include <ksimpleconfig.h>
#include <tdelocale.h>

KForwmachPageConfig::KForwmachPageConfig( TQWidget *parent, const char* name,
	KSimpleConfig *_config) 
    : TDECModule (parent, name)
{
    if (!_config) {
		delete_config = true;
		config = new KSimpleConfig("ktalkdrc");
	}
	else {
		delete_config = false;
		config = _config;
	}                                                                           
    forwmach_cb = new TQCheckBox(i18n("Activate &forward"), this);
    forwmach_cb->adjustSize();
    address_edit = new TQLineEdit(this);
    address_edit->adjustSize();
    address_edit->setMinimumWidth(150);
    address_label = new TQLabel(address_edit,i18n("&Destination (user or user@host):"),this);
    address_label->adjustSize();
    address_label->setAlignment( ShowPrefix | AlignVCenter );

    method_combo = new TQComboBox(this);
    method_combo->insertItem("FWA");
    method_combo->insertItem("FWR");
    method_combo->insertItem("FWT");
    method_combo->adjustSize();
    method_combo->setMinimumWidth(80);
    method_label = new TQLabel(method_combo, i18n("Forward &method:"),this);
    method_label->adjustSize();
    method_label->setAlignment( ShowPrefix | AlignVCenter );

    expl_label = new TQLabel(i18n(
"FWA: Forward announcement only. Direct connection. Not recommended.\n\
FWR: Forward all requests, changing info when necessary. Direct connection.\n\
FWT: Forward all requests and handle the talk request. No direct connection.\n\
\n\
Recommended use: FWT if you want to use it behind a firewall (and if ktalkd\n\
can access both networks). Otherwise choose FWR.\n\
\n\
See Help for further explanation.\n\
"),this);
    expl_label->adjustSize();

    int h = 10 + forwmach_cb->height() + address_edit->height() +
        method_combo->height()+expl_label->height()+30;
    setMinimumSize(400, h); // 400: otherwise, buttons may overlap

    load();

    connect(forwmach_cb, TQT_SIGNAL(clicked()), this, TQT_SLOT(forwmachOnOff()));

	// emit changed(true) on changes
	connect(forwmach_cb, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotChanged()));
	connect(address_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotChanged()));
	connect(method_combo, TQT_SIGNAL(activated(int)), this, TQT_SLOT(slotChanged()));
}

KForwmachPageConfig::~KForwmachPageConfig( ) {
	if (delete_config) delete config;
	
    /* I've been told that this is not necessary as 
       they will be deleted by TQt. But, well... */
    delete forwmach_cb;
    delete address_label;
    delete address_edit;
    delete method_label;
    delete method_combo;
    delete expl_label;
}

void KForwmachPageConfig::slotChanged() {
	emit changed(true);
}

void KForwmachPageConfig::resizeEvent(TQResizeEvent *) {
    int h_txt = forwmach_cb->height(); // taken for the general label height
    int h_edt = address_edit->height();   // taken for the general TQLineEdit height
    int spc = h_txt / 3;
    int w = rect().width();

    int h = 10 + spc*2;
    forwmach_cb->move(10, h);
    h += h_txt+spc;
    address_label->setFixedHeight(h_edt); // same size -> vertical center aligned
    address_label->move(10, h);
    int w_label = address_label->width()+20;
    address_edit->setGeometry(w_label, h, w-w_label-10, h_edt);
    h += h_edt+spc;

    method_label->setFixedHeight(h_edt); // same size -> vertical center aligned
    method_label->move(10, h);
    method_combo->move(w_label, h);
    h += h_edt+spc;

    expl_label->move(10,h);
    
}

void KForwmachPageConfig::forwmachOnOff() {
    bool b = forwmach_cb->isChecked();
    address_label->setEnabled(b);
    address_edit->setEnabled(b);
    method_label->setEnabled(b);
    method_combo->setEnabled(b);
    expl_label->setEnabled(b);
}

void KForwmachPageConfig::defaults() {

    forwmach_cb->setChecked(false);
    method_combo->setCurrentItem(1);
    address_edit->setText("");

    // Activate things according to configuration
    forwmachOnOff();

}

void KForwmachPageConfig::load() {
   
    config->setGroup("ktalkd");

    TQString forward = config->readEntry("Forward","unset");
    forwmach_cb->setChecked(forward!="unset");
    if (forward != "unset" ) 
        address_edit->setText(forward);
    else
        address_edit->setText("");

    TQString forwardMethod = config->readEntry("ForwardMethod","FWR");
    for (int i=0; i<method_combo->count(); i++)
        if (forwardMethod == method_combo->text(i))
            method_combo->setCurrentItem(i);

    // Activate things according to configuration
    forwmachOnOff();

    emit changed(false);
}

void KForwmachPageConfig::save() {

    config->setGroup("ktalkd");

    if (forwmach_cb->isChecked())
    {
        config->writeEntry("Forward",address_edit->text());
    } else
        config->deleteEntry("Forward", false /*non localized*/);
    config->writeEntry("ForwardMethod",method_combo->currentText());
    
    config->sync();
}

#include "forwmachpage.moc"
