/*
  Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this library; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef WIFICONFIG_H
#define WIFICONFIG_H

#include <tqstring.h>
#include <tqvaluelist.h>

#include "kcmwifi.h"

class TDEConfig;
class KSimpleConfig;

enum KeyStates { EMPTY=0, INVALID=1, HEX_64=2, HEX_128=3, HEX_256=4, STRING_64=5, STRING_128=6, STRING_256=7 };

class Key
{
  public:
    Key( const TQString &key );
    Key();

    TQString key() const { return m_key; }
    static KeyStates isValid( TQString keyCandidate );
    TQString rawKey() const;

    void setKey( const TQString &key );

  protected:
    TQString m_key;
};

typedef TQValueList<Key> KeyList;

class IfConfig
{
  public:
    IfConfig();

    enum Speed { AUTO=0, M1, M2, M55, M6, M9, M11, M12, M18, M24, M36, M48, M54 };
    enum WifiMode { AdHoc=0, Managed, Repeater, Master, Secondary };
    enum PowerMode { AllPackets=0, UnicastOnly, MulticastOnly };
    enum CryptoMode { Open=0, Restricted };

    void load( TDEConfig *config, int i );
    void save( TDEConfig *config, int i );

    TQString speedAsString();
    TQString wifimodeAsString();
    TQString cryptomodeAsString();
    TQString powermodeAsString();
    int activeKeyId();
    Key activeKey();

    static Speed convertToSpeedFromString( const TQString &s );
    static WifiMode convertToWifiModeFromString( const TQString &s );
    static PowerMode convertToPowerModeFromString( const TQString &s );
    static CryptoMode convertToCryptoModeFromString( const TQString &s );

    void speedFromString( const TQString &s );
    void wifimodeFromString( const TQString &s );
    void powermodeFromString( const TQString &s );
    void cryptomodeFromString( const TQString &s );

    TQString m_networkName;
    TQString m_interface;
    WifiMode m_wifiMode;
    Speed m_speed;
    bool m_runScript;
    TQString m_connectScript;

    bool m_useCrypto;
    CryptoMode m_cryptoMode;
    int m_activeKey;
    Key m_keys[ 4 ];

    bool m_pmEnabled;
    PowerMode m_pmMode;
    int m_sleepTimeout;
    int m_wakeupPeriod;
};

class WifiConfig : TQObject
{
  TQ_OBJECT
  
  public:
    static WifiConfig *instance();
    TQString autoDetectInterface();
    ~WifiConfig();

    void load();
    void save();

    IfConfig m_ifConfig[ KCMWifi::vendorBase+5 ];
    bool m_usePreset;
    int m_presetConfig;
    int m_numConfigs;

  private slots:
    void slotTestInterface( KProcIO *proc );

  private:
    WifiConfig();

    KSimpleConfig *m_config;
    static WifiConfig *m_instance;
    TQString m_detectedInterface;
};

#endif // WIFICONFIG_H
