/*
    msnswitchboardsocket.h - switch board connection socket

    Copyright (c) 2002      by Martijn Klingens       <klingens@kde.org>
    Copyright (c) 2002-2006 by Olivier Goffart        <ogoffart@ kde.org>
    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    Portions of this code are taken from KMerlin,
              (c) 2001 by Olaf Lueg              <olueg@olsd.de>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef MSNSWITCHBOARDSOCKET_H
#define MSNSWITCHBOARDSOCKET_H

#include <tqobject.h>
#include <tqstrlist.h>
#include <tqvaluevector.h>

#include <kstringhandler.h>

#include "msnsocket.h"

namespace Kopete { class Message; }
class MSNAccount;
class TQTimer;

class MSNP2PDisplatcher;
class KTempFile;

namespace P2P { class Dispatcher; }

#include "dispatcher.h"

class KOPETE_EXPORT MSNSwitchBoardSocket : public MSNSocket
{
	TQ_OBJECT
  

public:
	/**
	 * Contructor: id is the KopeteMessageMangager's id
	 */
	MSNSwitchBoardSocket( MSNAccount * account , TQObject *parent);
	~MSNSwitchBoardSocket();

private:
	P2P::Dispatcher *m_dispatcher;
	MSNAccount *m_account;

	TQString m_myHandle; // our handle

	// contains the handle of the last person that msg'ed us.
	// since we receive the actual message by readBlock(), we need
	// to remember what the handle was of the person sending us the message.
	TQString m_msgHandle;

	TQString m_ID;
	TQString m_auth;
	TQStringList m_chatMembers;

	//used for emoticons
	TQValueList<const Kopete::Message> m_msgQueue;
	unsigned  m_recvIcons;
	TQMap<TQString , TQPair<TQString , KTempFile*> >  m_emoticons;
	Kopete::Message &parseCustomEmoticons(Kopete::Message &msg);
	TQTimer *m_emoticonTimer;
	TQPtrList<KTempFile> m_typewrited;

	struct InkMessage{
		TQ_UINT32 chunks;
		TQString data;
	};
	TQMap<TQString, InkMessage> m_inkMessageBuffer;

	/** the number of chunk for currents messages */
	unsigned int m_chunks;

	/** true is we already sent the x-clientcaps message */
	bool m_clientcapsSent;

private:
	void DispatchInkMessage(const TQString &base64String);

protected:
	/**
	 * Handle an MSN command response line.
	 */
	virtual void parseCommand( const TQString &cmd, uint id,
		const TQString &data );

	/**
	 * Handle exceptions that might occur during a chat.
	 */
	virtual void handleError( uint code, uint id );

	TQString parseFontAttr( TQString str, TQString attr );


public:
	void connectToSwitchBoard( TQString ID, TQString address, TQString auth );
	void setHandle( TQString handle ) { m_myHandle = handle; }
	void setMsgHandle( TQString handle ) { m_msgHandle = handle; }

	const TQStringList &chatMembers() { return m_chatMembers; }

	void userLeftChat( const TQString &handle , const TQString &reason );
	int  sendMsg( const Kopete::Message &msg );
    int  sendCustomEmoticon(const TQString &name, const TQString &filename);

	int sendNudge();

	P2P::Dispatcher* PeerDispatcher();

public slots:
	void slotCloseSession();
	void slotInviteContact(const TQString &handle);

	/**
	 * Notify the server that the user is typing a message
	 */
	void sendTypingMsg( bool isTyping );

	void requestDisplayPicture();
	
	/** workaround Bug 113425 . see slotKeepAliveTimer() **/
	TQTimer *m_keepAlive;
	int m_keepAliveNb;
	


private slots:
	void slotOnlineStatusChanged( MSNSocket::OnlineStatus status );
	void slotSocketClosed(  );
	void slotReadMessage( const TQByteArray &bytes );
	void slotEmoticonReceived( KTempFile *, const TQString& );
	void slotIncomingFileTransfer(const TQString& from, const TQString& fileName, TQ_INT64 fileSize);
	void cleanQueue();
	
	/** workaround Bug 113425 . see comment inside the function **/
	void slotKeepAliveTimer();

signals:
	void msgReceived( Kopete::Message &msg );
	void receivedTypingMsg( const TQString &contactId, bool isTyping );
	void msgAcknowledgement(unsigned int, bool);
	void userJoined(const TQString& handle , const TQString &publicName , bool IRO);
	void userLeft(const TQString& handle , const TQString &reason);
	void nudgeReceived(const TQString &handle);

	void switchBoardClosed(  );
	void invitation(const TQString& handle, const TQString& msg);

};

#endif
