/*
 *        kPPP: A pppd front end for the KDE project
 *
 * $Id$
 *            Copyright (C) 1997  Bernd Wuebben
 *                 wuebben@math.cornel.edu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "debug.h"
#include "main.h"
#include "pppdata.h"
#include <tdelocale.h>

#include <assert.h>

extern KPPPWidget *p_kppp;

myMultiEdit::myMultiEdit(TQWidget *parent, const char *name)
  : TQMultiLineEdit(parent, name)
{
 setReadOnly(true);
}

void myMultiEdit::insertChar(unsigned char c) {
  TQMultiLineEdit::insert(TQChar(c));
}


void myMultiEdit::newLine() {
  TQMultiLineEdit::newLine();
}


DebugWidget::DebugWidget(TQWidget *parent, const char *name)
  : TQDialog(parent, name, FALSE)
{
  setCaption(i18n("Login Script Debug Window"));

  text_window = new myMultiEdit(this,"debugwindow");
  text_window->setGeometry(2,5,400, 300);
  //  text_window->setReadOnly(FALSE);

  statuslabel = new TQLabel("", this, "statuslabel");

  statuslabel->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );
  statuslabel->setAlignment( AlignLeft|AlignVCenter );
  statuslabel->setGeometry(2, 307, 400, 20);
  //statusPageLabel->setFont( TDEGlobalSettings::generalFont() );

  dismiss = new TQPushButton(this);
  dismiss->setGeometry(330,340,70,30);
  dismiss->setText(i18n("&Close"));
  dismiss->setFocus();
  connect(dismiss, TQ_SIGNAL(clicked()), TQ_SLOT(hide()));


  /*  fline = new TQFrame(this,"line");
  fline->setFrameStyle(TQFrame::HLine |TQFrame::Sunken);
  fline->setGeometry(2,332,398,5);*/
  adjustSize();
  setMinimumSize(width(),height());

}

void DebugWidget::hideEvent(TQHideEvent *)
{
  assert(p_kppp);
  p_kppp->con->debug->setOn(false);
}

void DebugWidget::clear() {
  text_window->clear(); 
}


void DebugWidget::addChar(unsigned char c) {
  TQString stuff;

  if(c == '\r' || c == '\n') {
    if(c == '\n')
      text_window->newLine();    
  } else
    text_window->insertChar(c);
}


void DebugWidget::statusLabel(const TQString &s) {
  statuslabel->setText(s);
}


/*
void DebugWidget::keyPressEvent(TQKeyEvent *k) {
}

*/
void DebugWidget::resizeEvent(TQResizeEvent *e){
  int w = width() ;
  int h = height();
  e = e;

  text_window->setGeometry(2,5,w - 2 ,h - 63);
  statuslabel->setGeometry(2, h - 56 , w -2 , 20);
  dismiss->setGeometry(w - 72 , h - 32, 70, 30);
  //  fline->setGeometry(2,h -70 ,w - 4,5);
}


void DebugWidget::enter() {
  text_window->append("\r\n");
}


void DebugWidget::toggleVisibility() {
  if(isVisible())
    hide();
  else
    show();

  bool showlog = isVisible();
  gpppdata.set_show_log_window(showlog);
}


#include "debug.moc"

