/*
    This file is part of KMail.
    Copyright (c) 2003      Laurent Montel <montel@kde.org>,
    Based on the work of Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KNODE_PART_H
#define KNODE_PART_H


#include <tdeversion.h>
#include <tdeparts/browserextension.h>
#include <tdeparts/factory.h>
#include <tdeparts/event.h>
#include <tdeparts/part.h>

#include <tqwidget.h>

class TDEInstance;
class TDEAboutData;

class ActionManager;
class KNMainWidget;

class KNodePart: public KParts::ReadOnlyPart
{
    Q_OBJECT
  
  public:
    KNodePart(TQWidget *parentWidget, const char *widgetName,
              TQObject *parent, const char *name, const TQStringList &);
    virtual ~KNodePart();

    TQWidget* parentWidget() const;

    static TDEAboutData *createAboutData();

  protected:
    virtual bool openFile();
    virtual void guiActivateEvent(KParts::GUIActivateEvent *e);

  private:
    ActionManager *mActionManager;
    TQWidget *mParentWidget;
    KNMainWidget *mainWidget;
};

#endif
