/*
    This file is part of Kontact.
    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>
#include <tqspinbox.h>

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdeaccelmanager.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include <tdelocale.h>

#include "kcmkorgsummary.h"

#include <kdemacros.h>

extern "C"
{
  KDE_EXPORT TDECModule *create_korgsummary( TQWidget *parent, const char * )
  {
    return new KCMKOrgSummary( parent, "kcmkorgsummary" );
  }
}

KCMKOrgSummary::KCMKOrgSummary( TQWidget *parent, const char *name )
  : TDECModule( parent, name )
{
  initGUI();

  customDaysChanged( 1 );

  connect( mCalendarGroup, TQT_SIGNAL( clicked( int ) ), TQT_SLOT( modified() ) );
  connect( mCalendarGroup, TQT_SIGNAL( clicked( int ) ), TQT_SLOT( buttonClicked( int ) ) );
  connect( mTodoGroup, TQT_SIGNAL( clicked( int ) ), TQT_SLOT( modified() ) );
  connect( mCustomDays, TQT_SIGNAL( valueChanged( int ) ), TQT_SLOT( modified() ) );
  connect( mCustomDays, TQT_SIGNAL( valueChanged( int ) ), TQT_SLOT( customDaysChanged( int ) ) );

  TDEAcceleratorManager::manage( this );

  load();

  TDEAboutData *about = new TDEAboutData( I18N_NOOP( "kcmkorgsummary" ),
                                      I18N_NOOP( "Schedule Configuration Dialog" ),
                                      0, 0, TDEAboutData::License_GPL,
                                      I18N_NOOP( "(c) 2003 - 2004 Tobias Koenig" ) );

  about->addAuthor( "Tobias Koenig", 0, "tokoe@kde.org" );
  setAboutData( about );
}

void KCMKOrgSummary::modified()
{
  emit changed( true );
}

void KCMKOrgSummary::buttonClicked( int id )
{
  mCustomDays->setEnabled( id == 4 );
}

void KCMKOrgSummary::customDaysChanged( int value )
{
  mCustomDays->setSuffix( i18n( " day",  " days", value ) );
}

void KCMKOrgSummary::initGUI()
{
  TQVBoxLayout *layout = new TQVBoxLayout( this, 0, KDialog::spacingHint() );

  mCalendarGroup = new TQButtonGroup( 0, Qt::Vertical, i18n( "Appointments" ), this );
  TQVBoxLayout *boxLayout = new TQVBoxLayout( mCalendarGroup->layout(),
                                            KDialog::spacingHint() );

  TQLabel *label = new TQLabel( i18n( "How many days should the calendar show at once?" ), mCalendarGroup );
  boxLayout->addWidget( label );

  TQRadioButton *button = new TQRadioButton( i18n( "One day" ), mCalendarGroup );
  boxLayout->addWidget( button );

  button = new TQRadioButton( i18n( "Five days" ), mCalendarGroup );
  boxLayout->addWidget( button );

  button = new TQRadioButton( i18n( "One week" ), mCalendarGroup );
  boxLayout->addWidget( button );

  button = new TQRadioButton( i18n( "One month" ), mCalendarGroup );
  boxLayout->addWidget( button );

  TQHBoxLayout *hbox = new TQHBoxLayout( boxLayout, KDialog::spacingHint() );

  button = new TQRadioButton( "", mCalendarGroup );
  hbox->addWidget( button );

  mCustomDays = new TQSpinBox( 1, 365, 1, mCalendarGroup );
  mCustomDays->setEnabled( false );
  hbox->addWidget( mCustomDays );

  hbox->addStretch( 1 );

  layout->addWidget( mCalendarGroup );

  mTodoGroup = new TQButtonGroup( 2, Qt::Horizontal, i18n( "To-dos" ), this );
  new TQRadioButton( i18n( "Show all to-dos" ), mTodoGroup );
  new TQRadioButton( i18n( "Show today's to-dos only" ), mTodoGroup );

  layout->addWidget( mTodoGroup );

  layout->addStretch();
}

void KCMKOrgSummary::load()
{
  TDEConfig config( "kcmkorgsummaryrc" );

  config.setGroup( "Calendar" );
  int days = config.readNumEntry( "DaysToShow", 1 );
  if ( days == 1 )
    mCalendarGroup->setButton( 0 );
  else if ( days == 5 )
    mCalendarGroup->setButton( 1 );
  else if ( days == 7 )
    mCalendarGroup->setButton( 2 );
  else if ( days == 31 )
    mCalendarGroup->setButton( 3 );
  else {
    mCalendarGroup->setButton( 4 );
    mCustomDays->setValue( days );
    mCustomDays->setEnabled( true );
  }

  config.setGroup( "Todo" );
  bool allTodos = config.readBoolEntry( "ShowAllTodos", false );

  if ( allTodos )
    mTodoGroup->setButton( 0 );
  else
    mTodoGroup->setButton( 1 );

  emit changed( false );
}

void KCMKOrgSummary::save()
{
  TDEConfig config( "kcmkorgsummaryrc" );

  config.setGroup( "Calendar" );

  int days;
  switch ( mCalendarGroup->selectedId() ) {
    case 0: days = 1; break;
    case 1: days = 5; break;
    case 2: days = 7; break;
    case 3: days = 31; break;
    case 4:
    default: days = mCustomDays->value(); break;
  }
  config.writeEntry( "DaysToShow", days );

  config.setGroup( "Todo" );
  config.writeEntry( "ShowAllTodos", mTodoGroup->selectedId() == 0 );

  config.sync();

  emit changed( false );
}

void KCMKOrgSummary::defaults()
{
  mCalendarGroup->setButton( 0 );
  mTodoGroup->setButton( 1 );

  emit changed( true );
}

#include "kcmkorgsummary.moc"
