/*
    obtainkeysjob.cpp

    This file is part of libkleopatra, the KDE keymanagement library
    Copyright (c) 2005 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "obtainkeysjob.h"

#include "chiasmusbackend.h"

#include "kleo/cryptoconfig.h"

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kshell.h>

#include <tqdir.h>
#include <tqstringlist.h>
#include <tqvariant.h>
#include <tqtimer.h>
#include <tqfileinfo.h>

#include <gpg-error.h>

#include <cassert>

Kleo::ObtainKeysJob::ObtainKeysJob()
  : SpecialJob( 0, 0 ),
    mIndex( 0 ),
    mCanceled( false )
{
  assert( ChiasmusBackend::instance() );
  assert( ChiasmusBackend::instance()->config() );
  const CryptoConfigEntry * keypaths =
    ChiasmusBackend::instance()->config()->entry( "Chiasmus", "General", "keydir" );
  assert( keypaths );
  mKeyPaths = TQStringList( keypaths->urlValue().path() );
}

Kleo::ObtainKeysJob::~ObtainKeysJob() {}

GpgME::Error Kleo::ObtainKeysJob::start() {
  TQTimer::singleShot( 0, this, TQT_SLOT(slotPerform()) );
  return mError = 0;
}

GpgME::Error Kleo::ObtainKeysJob::exec() {
  slotPerform( false );
  return mError;
}

void Kleo::ObtainKeysJob::slotCancel() {
  mCanceled = true;
}

void Kleo::ObtainKeysJob::slotPerform() {
  slotPerform( true );
}

void Kleo::ObtainKeysJob::slotPerform( bool async ) {
  if ( mCanceled && !mError )
    mError = gpg_error( GPG_ERR_CANCELED );
  if ( mIndex >= mKeyPaths.size() || mError ) {
    emit done();
    emit SpecialJob::result( mError, TQVariant( mResult ) );
    return;
  }

  emit progress( i18n( "Scanning directory %1..." ).arg( mKeyPaths[mIndex] ),
                 mIndex, mKeyPaths.size() );

  const TQDir dir( KShell::tildeExpand( mKeyPaths[mIndex] ) );

  if ( const TQFileInfoList * xisFiles = dir.entryInfoList( "*.xis;*.XIS", TQDir::Files ) )
    for ( TQFileInfoList::const_iterator it = xisFiles->begin(), end = xisFiles->end() ; it != end ; ++it )
      if ( (*it)->isReadable() )
        mResult.push_back( (*it)->absFilePath() );

  ++mIndex;

  if ( async )
    TQTimer::singleShot( 0, this, TQT_SLOT(slotPerform()) );
  else
    slotPerform( false );
}

void Kleo::ObtainKeysJob::showErrorDialog( TQWidget * parent, const TQString & caption ) const {
  if ( !mError )
    return;
  if ( mError.isCanceled() )
    return;
  const TQString msg = TQString::fromUtf8( mError.asString() );
  KMessageBox::error( parent, msg, caption );
}

#include "obtainkeysjob.moc"
