/*
    dnorderconfigpage.cpp

    This file is part of kleopatra, the KDE key manager
    Copyright (c) 2004 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License,
    version 2, as published by the Free Software Foundation.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#include "dnorderconfigpage.h"

#include <ui/dnattributeorderconfigwidget.h>
#include <kleo/dn.h>

#include <kdemacros.h>

#include <tqlayout.h>

DNOrderConfigPage::DNOrderConfigPage( TQWidget * parent, const char * name )
  : TDECModule( parent, name )
{
  TQVBoxLayout * vlay = new TQVBoxLayout( this );
  mWidget = Kleo::DNAttributeMapper::instance()->configWidget( this, "mWidget" );
  vlay->addWidget( mWidget );

  connect( mWidget, TQT_SIGNAL(changed()), TQT_SLOT(slotChanged()) );

#ifndef HAVE_UNBROKEN_KCMULTIDIALOG
  load();
#endif
}


void DNOrderConfigPage::load() {
  mWidget->load();
}

void DNOrderConfigPage::save() {
  mWidget->save();
}

void DNOrderConfigPage::defaults() {
  mWidget->defaults();
}

// tdelibs-3.2 didn't have the changed signal in TDECModule...
void DNOrderConfigPage::slotChanged() {
  emit changed(true);
}

extern "C" KDE_EXPORT TDECModule * create_kleopatra_config_dnorder( TQWidget * parent, const char * ) {
    return new DNOrderConfigPage( parent, "kleopatra_config_dnorder" );
}

#include "dnorderconfigpage.moc"
