/*
    gnupgviewer.cpp

    This file is part of libkleopatra's test suite.
    Copyright (c) 2004 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gnupgviewer.h"

#include <backends/qgpgme/gnupgprocessbase.h>

#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdemessagebox.h>
#include <kdebug.h>

#include <tqstringlist.h>

GnuPGViewer::GnuPGViewer( TQWidget * parent, const char * name )
  : TQTextEdit( parent, name ), mProcess( 0 )
{
  setTextFormat( LogText );
  setMaxLogLines( 10000 );
}

GnuPGViewer::~GnuPGViewer() {
  if ( mProcess )
    mProcess->kill();
}

void GnuPGViewer::setProcess( Kleo::GnuPGProcessBase * process ) {
  if ( !process )
    return;
  mProcess = process;
  connect( mProcess, TQT_SIGNAL(processExited(TDEProcess*)),
	   TQT_SLOT(slotProcessExited(TDEProcess*)) );
  connect( mProcess, TQT_SIGNAL(receivedStdout(TDEProcess*,char*,int)),
	   TQT_SLOT(slotStdout(TDEProcess*,char*,int)) );
  connect( mProcess, TQT_SIGNAL(receivedStderr(TDEProcess*,char*,int)),
	   TQT_SLOT(slotStderr(TDEProcess*,char*,int)) );
  connect( mProcess, TQT_SIGNAL(status(Kleo::GnuPGProcessBase*,const TQString&,const TQStringList&)),
	   TQT_SLOT(slotStatus(Kleo::GnuPGProcessBase*,const TQString&,const TQStringList&)) );
}

static TQStringList split( char * buffer, int buflen, TQString & old ) {
  // when done right, this would need to use TQTextCodec...
  const TQString str = old + TQString::fromLocal8Bit( buffer, buflen );
  TQStringList l = TQStringList::split( '\n', str, true );
  if ( l.empty() )
    return l;
  if ( str.endsWith( "\n" ) ) {
    old = TQString();
  } else {
    old = l.back();
    l.pop_back();
  }
  return l;
}

static TQString escape( TQString str ) {
  return str.replace( '&', "&amp" ).replace( '<', "&lt;" ).replace( '>', "&gt;" );
}

void GnuPGViewer::slotStdout( TDEProcess *, char * buffer, int buflen ) {
  const TQStringList l = split( buffer, buflen, mLastStdout );
  for ( TQStringList::const_iterator it = l.begin() ; it != l.end() ; ++it )
    append( "stdout: " + escape( *it ) );
}

void GnuPGViewer::slotStderr( TDEProcess *, char * buffer, int buflen ) {
  const TQStringList l = split( buffer, buflen, mLastStderr );
  for ( TQStringList::const_iterator it = l.begin() ; it != l.end() ; ++it )
    append( "<b>stderr: " + escape( *it ) + "</b>" );
}
void GnuPGViewer::slotStatus( Kleo::GnuPGProcessBase *, const TQString & type, const TQStringList & args ) {
  append( "<b><font color=\"red\">status: " + escape( type + ' ' + args.join( " " ) ) + "</font></b>" );
}
void GnuPGViewer::slotProcessExited( TDEProcess * proc ) {
  if ( !proc )
    return;
  if ( proc->normalExit() )
    append( TQString( "<b>Process exit: return code %1</b>" ).arg ( proc->exitStatus() ) );
  else
    append( "<b>Process exit: killed</b>" );
}

int main( int argc, char** argv ) {
  if ( argc < 3 ) {
    kdDebug() << "Need at least two arguments" << endl;
    return 1;
  }
  TDEAboutData aboutData( "test_gnupgprocessbase", "GnuPGProcessBase Test", "0.1" );
  TDECmdLineArgs::init( &aboutData );
  TDEApplication app;

  Kleo::GnuPGProcessBase gpg;
  for ( int i = 1 ; i < argc ; ++i )
    gpg << argv[i];

  gpg.setUsetStatusFD( true );

  GnuPGViewer * gv = new GnuPGViewer();
  gv->setProcess( &gpg );

  app.setMainWidget( gv );
  gv->show();

  gpg.start( TDEProcess::NotifyOnExit, TDEProcess::AllOutput );

  return app.exec();
}

#include "gnupgviewer.moc"
