/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef CONTACTLISTVIEW_H
#define CONTACTLISTVIEW_H

#include <tqcolor.h>
#include <tqpixmap.h>
#include <tqtooltip.h>
#include <tqstring.h>

#include <tdelistview.h>

#include <tdeabc/field.h>

class TQDropEvent;
class KAddressBookTableView;
class ContactListView;
class KIMProxy;

/** The whole tooltip design needs a lot of work. Currently it is
* hacked together to function.
*/
class DynamicTip : public TQToolTip
{
  public:
    DynamicTip( ContactListView * parent );

  protected:
    void maybeTip( const TQPoint & );

  private:
};

class ContactListViewItem : public TDEListViewItem
{

public:
  ContactListViewItem(const TDEABC::Addressee &a, ContactListView* parent,
                      TDEABC::AddressBook *doc, const TDEABC::Field::List &fields, KIMProxy *proxy );
  const TDEABC::Addressee &addressee() const { return mAddressee; }
  virtual void refresh();
  virtual ContactListView* parent();
  virtual TQString key ( int, bool ) const;
  void setHasIM( bool hasIM );
  /** Adds the border around the cell if the user wants it.
  * This is how the single line config option is implemented.
  */
  virtual void paintCell(TQPainter * p, const TQColorGroup & cg,
                         int column, int width, int align );

private:
  TDEABC::Addressee mAddressee;
  TDEABC::Field::List mFields;
  ContactListView *parentListView;
  TDEABC::AddressBook *mDocument;
  KIMProxy *mIMProxy;
  bool mHasIM;
};


/////////////////////////////////////////////
// ContactListView

class ContactListView : public TDEListView
{
  TQ_OBJECT
  

public:
  ContactListView(KAddressBookTableView *view,
                  TDEABC::AddressBook *doc,
                  TQWidget *parent,
                  const char *name = 0L );
  virtual ~ContactListView() {}
  //void resort();

  /** Returns true if tooltips should be displayed, false otherwise
  */
  bool tooltips() const { return mToolTips; }
  void setToolTipsEnabled(bool enabled) { mToolTips = enabled; }

  bool alternateBackground() const { return mABackground; }
  void setAlternateBackgroundEnabled(bool enabled);

  bool singleLine() const { return mSingleLine; }
  void setSingleLineEnabled(bool enabled) { mSingleLine = enabled; }

  const TQColor &alternateColor() const { return mAlternateColor; }

  /** Sets the background pixmap to <i>filename</i>. If the
  * TQString is empty (TQString::isEmpty()), then the background
  * pixmap will be disabled.
  */
  void setBackgroundPixmap(const TQString &filename);

  /**
   * Sets whether instant messaging presence should be shown in the first column
   */
  void setShowIM( bool enabled );

  /**
   * Is presence being shown?
   */
  bool showIM();

  /**
   * Set the column index of the column used for instant messaging presence.
   * This method is necessary because presence, unlike the other fields, is not
   * a TDEABC::Field, and cannot be handled using their methods.
   * TODO: make presence a TDEABC::Field post 3.3
   */
  void setIMColumn( int column );

  /**
   * get the column used for IM presence
   */
  int imColumn();

protected:
  /** Paints the background pixmap in the empty area. This method is needed
  * since TQt::FixedPixmap will not scroll with the list view.
  */
  virtual void paintEmptyArea( TQPainter * p, const TQRect & rect );
  virtual void contentsMousePressEvent(TQMouseEvent*);
  void contentsMouseMoveEvent( TQMouseEvent *e );
  void contentsDropEvent( TQDropEvent *e );
  virtual bool acceptDrag(TQDropEvent *e) const;

protected slots:
  void itemDropped(TQDropEvent *e);

public slots:

signals:
  void startAddresseeDrag();
  void addresseeDropped(TQDropEvent *);

private:
  KAddressBookTableView *pabWidget;
  int oldColumn;
  int column;
  bool ascending;

  bool mABackground;
  bool mSingleLine;
  bool mToolTips;
  bool mShowIM;

  TQColor mAlternateColor;

  TQPoint presspos;
  int mInstantMsgColumn;
};


#endif
