/*
    This file is part of KAddressbook.
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqlayout.h>

#include <tdeabc/addressbook.h>
#include <tdeabc/resource.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <ktrader.h>
#include <tdeapplication.h>

#include "core.h"
#include "kablock.h"
#include "undocmds.h"
#include "xxportselectdialog.h"

#include "xxportmanager.h"

KURL XXPortManager::importURL = KURL();
TQString XXPortManager::importData = TQString();

XXPortManager::XXPortManager( KAB::Core *core, TQObject *parent, const char *name )
  : TQObject( parent, name ), mCore( core )
{
  loadPlugins();
}

XXPortManager::~XXPortManager()
{
}

void XXPortManager::restoreSettings()
{
}

void XXPortManager::saveSettings()
{
}

void XXPortManager::importVCard( const KURL &url )
{
  importURL = url;
  slotImport( "vcard", "<empty>" );
  importURL = KURL();
}

void XXPortManager::importVCardFromData( const TQString &vCard )
{
  importData = vCard;
  slotImport( "vcard", "<empty>" );
  importData = "";
}

void XXPortManager::slotImport( const TQString &identifier, const TQString &data )
{
  KAB::XXPort *obj = mXXPortObjects[ identifier ];
  if ( !obj ) {
    KMessageBox::error( mCore->widget(), i18n( "<qt>No import plugin available for <b>%1</b>.</qt>" ).arg( identifier ) );
    return;
  }

  TDEABC::Resource *resource = mCore->requestResource( mCore->widget() );
  if ( !resource )
    return;

  TDEABC::AddresseeList list = obj->importContacts( data );
  TDEABC::AddresseeList::Iterator it;
  for ( it = list.begin(); it != list.end(); ++it )
    (*it).setResource( resource );

  if ( !list.isEmpty() ) {
    NewCommand *command = new NewCommand( mCore->addressBook(), list );
    mCore->commandHistory()->addCommand( command );
    emit modified();
  }
}

void XXPortManager::slotExport( const TQString &identifier, const TQString &data )
{
  KAB::XXPort *obj = mXXPortObjects[ identifier ];
  if ( !obj ) {
    KMessageBox::error( mCore->widget(), i18n( "<qt>No export plugin available for <b>%1</b>.</qt>" ).arg( identifier ) );
    return;
  }

  TDEABC::AddresseeList addrList;
  XXPortSelectDialog dlg( mCore, obj->requiresSorting(), mCore->widget() );
  if ( dlg.exec() )
    addrList = dlg.contacts();
  else
    return;

  if ( !obj->exportContacts( addrList, data ) )
    KMessageBox::error( mCore->widget(), i18n( "Unable to export contacts." ) );
}

void XXPortManager::loadPlugins()
{
  mXXPortObjects.clear();

  const TDETrader::OfferList plugins = TDETrader::self()->query( "KAddressBook/XXPort",
    TQString( "[X-TDE-KAddressBook-XXPortPluginVersion] == %1" ).arg( KAB_XXPORT_PLUGIN_VERSION ) );
  TDETrader::OfferList::ConstIterator it;
  for ( it = plugins.begin(); it != plugins.end(); ++it ) {
    if ( !(*it)->hasServiceType( "KAddressBook/XXPort" ) )
      continue;

    KLibFactory *factory = KLibLoader::self()->factory( (*it)->library().latin1() );
    if ( !factory ) {
      kdDebug(5720) << "XXPortManager::loadExtensions(): Factory creation failed" << endl;
      continue;
    }

    KAB::XXPortFactory *xxportFactory = static_cast<KAB::XXPortFactory*>( factory );

    if ( !xxportFactory ) {
      kdDebug(5720) << "XXPortManager::loadExtensions(): Cast failed" << endl;
      continue;
    }

    KAB::XXPort *obj = xxportFactory->xxportObject( mCore->addressBook(), mCore->widget() );
    if ( obj ) {
      if ( mCore->guiClient() )
        mCore->guiClient()->insertChildClient( obj );

      mXXPortObjects.insert( obj->identifier(), obj );
      connect( obj, TQT_SIGNAL( exportActivated( const TQString&, const TQString& ) ),
               this, TQT_SLOT( slotExport( const TQString&, const TQString& ) ) );
      connect( obj, TQT_SIGNAL( importActivated( const TQString&, const TQString& ) ),
               this, TQT_SLOT( slotImport( const TQString&, const TQString& ) ) );

      obj->setTDEApplication( kapp );
    }
  }
}

#include "xxportmanager.moc"
