/*
   This file is part of the KDE project
   Copyright (C) 2004-2006 Michael Brade <brade@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

   In addition, as a special exception, the copyright holders give
   permission to link the code of this program with any edition of
   the TQt library by Trolltech AS, Norway (or with modified versions
   of TQt that use the same license as TQt), and distribute linked
   combinations including the two.  You must obey the GNU General
   Public License in all respects for all of the code used other than
   TQt.  If you modify this file, you may extend this exception to
   your version of the file, but you are not obligated to do so.  If
   you do not wish to do so, delete this exception statement from
   your version.
*/

#ifndef KNOTES_PART_P_H
#define KNOTES_PART_P_H

#include <tqlayout.h>
#include <tqlabel.h>

#include <tdeactioncollection.h>
#include <tdelocale.h>
#include <kiconview.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <kiconeffect.h>
#include <klineedit.h>
#include <tdetoolbar.h>
#include <tdepopupmenu.h>
#include <kdialogbase.h>
#include <kxmlguiclient.h>
#include <kxmlguifactory.h>
#include <kxmlguibuilder.h>

#include <libkcal/calendarlocal.h>
#include <libkcal/journal.h>
#include <libkcal/icaldrag.h>
#include <libtdepim/kpimprefs.h>

#include "knotes/knoteedit.h"


class KNotesIconViewItem : public TDEIconViewItem
{
  public:
    KNotesIconViewItem( TDEIconView *parent, KCal::Journal *journal )
      : TDEIconViewItem( parent ),
        mJournal( journal )
    {
      setRenameEnabled( true );

      TDEIconEffect effect;
      TQColor color( journal->customProperty( "KNotes", "BgColor" ) );
      TQPixmap icon = TDEGlobal::iconLoader()->loadIcon( "knotes", TDEIcon::Desktop );
      icon = effect.apply( icon, TDEIconEffect::Colorize, 1, color, false );
      setPixmap( icon );
      TDEIconViewItem::setText( journal->summary() );
    }

    KCal::Journal *journal()
    {
      return mJournal;
    }

    virtual void setText( const TQString& text )
    {
      TDEIconViewItem::setText( text );
      mJournal->setSummary( text );
    }

  private:
    KCal::Journal *mJournal;
};


class KNotesIconView : public TDEIconView
{
  protected:
    TQDragObject* dragObject()
    {
      TQValueList<KNotesIconViewItem*> selectedItems;
      for ( TQIconViewItem *it = firstItem(); it; it = it->nextItem() ) {
        if ( it->isSelected() )
          selectedItems.append( static_cast<KNotesIconViewItem *>( it ) );
      }
      if ( selectedItems.count() != 1 )
        return TDEIconView::dragObject();

      KCal::CalendarLocal cal( KPimPrefs::timezone() );
      KCal::Incidence *i = selectedItems.first()->journal()->clone();
      cal.addIncidence( i );
      KCal::ICalDrag *icd = new KCal::ICalDrag( &cal, this );
      return icd;
    }
};


class KNoteEditDlg : public KDialogBase, virtual public KXMLGUIClient
{
  TQ_OBJECT
  

  public:
    KNoteEditDlg( TQWidget *parent = 0, const char *name = 0 )
      : KDialogBase( Plain, i18n( "Edit Note" ), Ok | Cancel, Ok,
                     parent, name, true, true )
    {
      // this dialog is modal to prevent one from editing the same note twice in two
      // different windows

      setInstance( new TDEInstance( "knotes" ) ); // TODO: hm, memleak??
      setXMLFile( "knotesui.rc" );
      actionCollection()->setWidget( this );

      TQWidget *page = plainPage();
      TQVBoxLayout *layout = new TQVBoxLayout( page );

      TQHBoxLayout *hbl = new TQHBoxLayout( layout, marginHint() );
      TQLabel *label = new TQLabel( page);
      label->setText( i18n( "Name:" ) );
      hbl->addWidget( label,0 );
      mTitleEdit= new KLineEdit( page, "name" );
      hbl->addWidget( mTitleEdit, 1,TQt::AlignVCenter  );

      mNoteEdit = new KNoteEdit( actionCollection(), page );
      mNoteEdit->setTextFormat( RichText );
      mNoteEdit->setFocus();

      KXMLGUIBuilder builder( page );
      KXMLGUIFactory factory( &builder, TQT_TQOBJECT(this) );
      factory.addClient( this );

      mTool = static_cast<TDEToolBar *>(factory.container( "note_tool", this ));

      layout->addWidget( mTool );
      layout->addWidget( mNoteEdit );
    }

    TQString text() const
    {
      return mNoteEdit->text();
    }

    void setText( const TQString& text )
    {
      mNoteEdit->setText( text );
    }

    TQString title() const
    {
      return mTitleEdit->text();
    }

    void setTitle( const TQString& text )
    {
      mTitleEdit->setText( text );
    }

    void setRichText( bool rt )
    {
      mNoteEdit->setTextFormat( rt ? RichText : PlainText );
    }

  private:
    KLineEdit  *mTitleEdit;
    KNoteEdit  *mNoteEdit;
    TDEToolBar   *mTool;
    TDEPopupMenu *mEditMenu;
};


#endif
