#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeglobal.h>
#include <tdelocale.h>

#include "groupwarewizard.h"

static const TDECmdLineOptions options[] =
{
  { "serverType <type>", "The server type", 0 },
  TDECmdLineLastOption
};

int main( int argc, char **argv )
{
  TDELocale::setMainCatalogue( "tdepimwizards" );

  TDEAboutData aboutData( "groupwarewizard",
                        I18N_NOOP( "TDE-PIM Groupware Configuration Wizard" ), "0.1" );
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );

  TDEApplication app;

  TDEGlobal::locale()->insertCatalogue( "libtdepim" );

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  TQString serverType;
  if ( args->isSet( "serverType" ) )
    serverType = args->getOption( "serverType" );

  GroupwareWizard wizard( 0 );
  app.setMainWidget( &wizard );

  wizard.show();

  app.exec();
}
