/*
    progressbar.cpp

    This file is part of libkleopatra, the KDE keymanagement library
    Copyright (c) 2004 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#include "config.h"
#include "progressbar.h"

#include <tqtimer.h>
#include <kdebug.h>

static const int busyTimerTickInterval = 100;
static const int busyTimerTickIncrement = 5;

Kleo::ProgressBar::ProgressBar( TQWidget * parent, const char * name, WFlags f )
  : TQProgressBar( 0, parent, name, f ),
    mRealProgress( -1 )
{
  mBusyTimer = new TQTimer( this );
  connect( mBusyTimer, TQ_SIGNAL(timeout()), TQ_SLOT(slotBusyTimerTick()) );
  fixup( true );
}

void Kleo::ProgressBar::slotProgress( const TQString &, int cur, int tot ) {
  setProgress( cur, tot );
}

void Kleo::ProgressBar::slotProgress( const TQString &, int, int cur, int tot ) {
  setProgress( cur, tot );
}

void Kleo::ProgressBar::setTotalSteps( int total ) {
  kdDebug() << "Kleo::ProgressBar::setTotalSteps( " << total << " )" << endl;
  if ( total == totalSteps() )
    return;
  TQProgressBar::setTotalSteps( 0 );
  fixup( false );
}

void Kleo::ProgressBar::setProgress( int p ) {
  kdDebug() << "Kleo::ProgressBar::setProgress( " << p << " )" << endl;
  mRealProgress = p;
  fixup( true );
}

void Kleo::ProgressBar::reset() {
  mRealProgress = -1;
  fixup( true );
}

void Kleo::ProgressBar::slotBusyTimerTick() {
  fixup( false );
  if ( mBusyTimer->isActive() )
    TQProgressBar::setProgress( TQProgressBar::progress() + busyTimerTickIncrement );
}

void Kleo::ProgressBar::fixup( bool newValue ) {
  const int cur = TQProgressBar::progress();
  const int tot = TQProgressBar::totalSteps();

  kdDebug() << "Kleo::ProgressBar::startStopBusyTimer() cur = " << cur << "; tot = " << tot << "; real = " << mRealProgress << endl;

  if ( ( newValue && mRealProgress < 0 ) || ( !newValue && cur < 0 ) ) {
    kdDebug() << "(new value) switch to reset" << endl;
    mBusyTimer->stop();
    if ( newValue )
      TQProgressBar::reset();
    mRealProgress = -1;
  } else if ( tot == 0 ) {
    kdDebug() << "(new value) switch or stay in busy" << endl;
    if ( !mBusyTimer->isActive() ) {
      mBusyTimer->start( busyTimerTickInterval );
      if ( newValue )
	TQProgressBar::setProgress( mRealProgress );
    }
  } else {
    kdDebug() << "(new value) normal progress" << endl;
    mBusyTimer->stop();
    if ( TQProgressBar::progress() != mRealProgress )
      TQProgressBar::setProgress( mRealProgress );
  }
}

#include "progressbar.moc"
