/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef BLAMEDISPLAY_IMPL_H
#define BLAMEDISPLAY_IMPL_H

#include "blamedisplay.h"
#include "client.h"

class BlameDisplayData;
class SimpleLogCb;
class BlameDisplayItem;
class TDEListViewSearchLineWidget;

class BlameDisplay_impl:public BlameDisplay
{
    Q_OBJECT
  
public:
    BlameDisplay_impl(const TQString&,const svn::AnnotatedFile&,TQWidget*parent=0,const char*name=0);
    BlameDisplay_impl(TQWidget*parent=0,const char*name=0);
    virtual ~BlameDisplay_impl();

    virtual void setContent(const TQString&,const svn::AnnotatedFile&);
    virtual void setCb(SimpleLogCb*);

    const TQColor rev2color(svn_revnum_t)const;

    static void displayBlame(SimpleLogCb*,const TQString&,const svn::AnnotatedFile&,TQWidget*parent=0,const char*name=0);

public slots:
    virtual void slotGoLine();
    virtual void slotShowCurrentCommit();

protected slots:
    virtual void slotContextMenuRequested(TDEListView*,TQListViewItem*, const TQPoint&);
    virtual void slotSelectionChanged();
    virtual void slotTextCodecChanged(const TQString&);

protected:
    virtual void showCommit(BlameDisplayItem*);
    TDEListViewSearchLineWidget* m_SearchWidget;

private:
    BlameDisplayData*m_Data;
protected slots:
    virtual void slotItemDoubleClicked(TQListViewItem*);
};

#endif
