#include  "complex.h"
#include  "screen.h"
#include  "cif.h"
#include  "cif_i.h"

#define  SM  0
#define  PM  1
#define  STD 2

#define MaxLenReq 222

dword takt_cpu(void);
#pragma aux takt_cpu = "db 0Fh,31h "\
                       modify [EDX] \
                       value [EAX]  ;

extern dword time_virt[MAX_CONTR];

typedef struct TSK_glb_parm_tag
{
 struct TSK_glb_parm_tag *next;
 int n_contr;
 int check_st;           //ਧ  ஬ ந室  㤠  設
 int no_scan_DB;         //ਧ ⢨ ᭮ DB
 int last_time;
 int last_kz;
}TSK_glb_parm;

TSK_glb_parm *glb_parm=NULL;

int GetKZ(controller *ctr, word_s kztmp, word param);
byte *revers(byte *buff, word_s len);

void taskS7(controller *ptr_c)
{
 char buffer[250],tmp_b;
 int i,ii,min, max,len_max ,len;
 word_s val, kzgen,kztmp,kztmp1,tmp;
 analog *ptr_a;
 digit *ptr_d;
 dword takt_old;
 TSK_glb_parm *glob;

 min = 100000; max = 0;

 glob=glb_parm;
 while(glob && glob->n_contr!=ptr_c->nom_ord) glob=glob->next;
 if(!glob) return;

 while(!endrun)
 {
  wait_flag_set(ptr_c->flag, 0L);
  clear_flag(ptr_c->flag);
  request_resource(ptr_c->port_rsc,0L);     // 墠 p-p
//-----------------
  if(yes_P5)takt_old=takt_cpu();
//-----------------

  kzgen=kztmp=kztmp1=0;
  if(glob->check_st)
  {
   tmp=FindSt_CIF(ptr_c->nomport,ptr_c->vector,ptr_c->nom_ord+1);
   if(tmp==1) glob->check_st=0; else kzgen|=0x8000; //kztmp= 17;
  }
  //eprintf(RED_,"Find ST - %d (%d),",kztmp,glob->check_st);
  if(glob->no_scan_DB) {kzgen=ptr_c->basaddr; kzgen|=0x6000; }
  else if(!glob->check_st)
  {
//------------ ᪠     ࠬ஢ ------
   if(ptr_c->IRQ_line != 0)
   {
     min = 100000; max = 0;
     for(i=0,ptr_a=ptr_c->a_ptr; i < ptr_c->num_ap; i++, ptr_a++)
     {
      if(ptr_a->type_mech != M_INP || ptr_a->dif_var == 0 || ptr_a->pasive )  continue;                 //쪮 室
      if(ptr_a->nomin_var < min) min = ptr_a->nomin_var;
      if(ptr_a->nomin_var > max) {max = ptr_a->nomin_var; len_max=2;}
     }

     for(i=0,ptr_d=ptr_c->d_ptr; i < ptr_c->num_dp; i++, ptr_d++)
     {
      if(ptr_d->type_par!=0 || ptr_d->type_com != 1 || ptr_d->dif_par == 0 || ptr_d->pasive)  continue; //쪮 室
      if(ptr_d->nom_var < min) min = ptr_d->nom_var;
      if(ptr_d->nom_var > max) {max = ptr_d->nom_var; len_max=1;}
     }

     if(max>=min)
     {
      if((max+len_max)%MaxLenReq) len=((max+len_max)/MaxLenReq)+1;
      else                        len=((max+len_max)/MaxLenReq);
      for(ii=0;ii<len;ii++)
      {
       min = 100000; max = 0;
       for(i=0,ptr_a=ptr_c->a_ptr; i < ptr_c->num_ap; i++, ptr_a++)
       {
        if(ptr_a->type_mech!=M_INP || ptr_a->dif_var == 0 || ptr_a->pasive ||
           (ptr_a->nomin_var+2) > (MaxLenReq*(ii+1)) || (ptr_a->nomin_var+2) < (MaxLenReq*ii))  continue;
        if(ptr_a->nomin_var<min) min = ptr_a->nomin_var;
        if(ptr_a->nomin_var>max){ max = ptr_a->nomin_var; len_max=2; }
       }
       for(i=0,ptr_d=ptr_c->d_ptr; i < ptr_c->num_dp; i++, ptr_d++)
       {
        if(ptr_d->type_par!=0 || ptr_d->type_com!=1 || ptr_d->dif_par == 0 || ptr_d->pasive ||
           (ptr_d->nom_var+1) > (MaxLenReq*(ii+1)) || (ptr_d->nom_var+1) < (MaxLenReq*ii))  continue;
        if(ptr_d->nom_var<min) min = ptr_d->nom_var;
        if(ptr_d->nom_var>max){ max = ptr_d->nom_var; len_max=1; }
       }
       if(max>=min)
       {
        if(glob->check_st)        kzgen|=0x8000;  // kztmp = 17;
        else if(glob->no_scan_DB) {kzgen=ptr_c->basaddr; kzgen|=0x6000; } // kztmp=0x85;
        else
        {
         kztmp=GetDB_CIF(ptr_c->nomport,ptr_c->vector,ptr_c->nom_ord+1,ptr_c->basaddr,MaxLenReq*ii,max-MaxLenReq*ii+len_max,&buffer);
//         eprintf(RED_,"ERROR TEST_0 %x",kztmp);
//       if(kztmp== -1 || kztmp== -2) {glob->no_scan_DB=1; kzgen|=0x0800; goto kz_end;}
         if(kztmp== -3 || kztmp== -4 || kztmp== 17) { kzgen|=0x8000; glob->check_st=1;}
         else if(kztmp==0x85) {kzgen=ptr_c->basaddr; kzgen|=0x6000; glob->no_scan_DB=1; }
         else if(kztmp==0x87) {kzgen=ptr_c->basaddr; kzgen|=0x4000; }
         else if(kztmp) { kzgen=kztmp; kzgen|=0x1000; }
        }
        for(i=0,ptr_a=ptr_c->a_ptr;i< ptr_c->num_ap;i++,ptr_a++)
        {
         if(ptr_a->type_mech!=M_INP || ptr_a->dif_var == 0 || ptr_a->pasive || (ptr_a->nomin_var+2) > (MaxLenReq*(ii+1)) || (ptr_a->nomin_var+2) < (MaxLenReq*ii)) continue;
         if(kztmp) {ptr_a->hard_err=1; continue;}

         val=ptr_a->dif_cod/K_S7;
         val=*(word_s *)revers((char *)&val,2);
         *(word_s *)(buffer+ptr_a->nomin_var-MaxLenReq*ii)=val;
         ptr_a->hard_err = 0;
        }
        for(i=0,ptr_d=ptr_c->d_ptr;i< ptr_c->num_dp;i++,ptr_d++)
        {
         if( ptr_d->type_par!=0 || ptr_d->type_com!=1 || ptr_d->dif_par == 0 || ptr_d->pasive ||
            (ptr_d->nom_var+1) > (MaxLenReq*(ii+1)) || (ptr_d->nom_var+1) < (MaxLenReq*ii)) continue;
         if(kztmp) {ptr_d->hard_err=1; continue;}

         tmp_b=1<<ptr_d->nom_vr2;
         if(ptr_d->val_pr2) buffer[ptr_d->nom_var-MaxLenReq*ii]|=tmp_b;
         else               buffer[ptr_d->nom_var-MaxLenReq*ii]&=(~tmp_b);
         ptr_d->hard_err=0;
        }
        if(kztmp) continue;
        kztmp=PutDB_CIF(ptr_c->nomport,ptr_c->vector,ptr_c->nom_ord+1,ptr_c->basaddr,MaxLenReq*ii,max-MaxLenReq*ii+len_max,&buffer);
//        eprintf(RED_,"ERROR TEST_1 %x",kztmp);
        if(kztmp== -3 || kztmp== -4 || kztmp== 17) { kzgen|=0x8000; glob->check_st=1;}
        else if(kztmp==0x85) {kzgen=ptr_c->basaddr; kzgen|=0x6000; glob->no_scan_DB=1; }
        else if(kztmp==0x87) {kzgen=ptr_c->basaddr; kzgen|=0x4000; }
        else if(kztmp) { kzgen=kztmp; kzgen|=0x1000; }

        for(i=0,ptr_a=ptr_c->a_ptr;i< ptr_c->num_ap;i++,ptr_a++)
        {
         if(ptr_a->type_mech!=M_INP || ptr_a->dif_var == 0 || ptr_a->pasive || (ptr_a->nomin_var+2) > (MaxLenReq*(ii+1)) || (ptr_a->nomin_var+2) < (MaxLenReq*ii)) continue;
         if(kztmp) {ptr_a->hard_err=1; continue;}

         ptr_a->var_cod  = ptr_a->dif_cod;
         ptr_a->var_tech = valtec(ptr_a,ptr_a->var_cod);
         ptr_a->dif_var  = 0;
         ptr_a->hard_err = 0;
        }
        for(i=0,ptr_d=ptr_c->d_ptr;i< ptr_c->num_dp;i++,ptr_d++)
        {
         if( ptr_d->type_par!=0 || ptr_d->type_com!=1 || ptr_d->dif_par == 0 || ptr_d->pasive ||
            (ptr_d->nom_var+1) > (MaxLenReq*(ii+1)) || (ptr_d->nom_var+1) < (MaxLenReq*ii)) continue;
         if(kztmp) {ptr_d->hard_err=1; continue;}

         ptr_d->val_par  = ptr_d->val_pr2;
         ptr_d->dif_par  = 0;
         ptr_d->hard_err = 0;
        }
       }
      }
     }
   }
//------------     ࠬ஢ -------------------
   min = 100000; max = 0;
   for(i=0,ptr_a=ptr_c->a_ptr; i < ptr_c->num_ap; i++, ptr_a++)
   {
    if(/*ptr_a->type_mech==M_INP ||*/ ptr_a->nolog || ptr_a->pasive)  continue;
    if(ptr_a->nomin_var < min) min = ptr_a->nomin_var;
    if(ptr_a->nomin_var > max) {max = ptr_a->nomin_var; len_max=2;}
   }
   for(i=0,ptr_d=ptr_c->d_ptr; i < ptr_c->num_dp; i++, ptr_d++)
   {
    if(ptr_d->type_par!=0 || ptr_d->nolog || ptr_d->type_com==0 || ptr_d->pasive)  continue;
    if(ptr_d->nom_var < min) min = ptr_d->nom_var;
    if(ptr_d->nom_var > max) {max = ptr_d->nom_var; len_max=1;}
   }
   if(max>=min)
   {
    if((max+len_max)%MaxLenReq) len=((max+len_max)/MaxLenReq)+1;
    else                        len=((max+len_max)/MaxLenReq);
    for(ii=0;ii<len;ii++)
    {
     min = 100000; max = 0;
     for(i=0,ptr_a=ptr_c->a_ptr; i < ptr_c->num_ap; i++, ptr_a++)
     {
      if(/*ptr_a->type_mech==M_INP ||*/ ptr_a->nolog || ptr_a->pasive ||
         (ptr_a->nomin_var+2) > (MaxLenReq*(ii+1)) || (ptr_a->nomin_var+2) < (MaxLenReq*ii))  continue;
      if(ptr_a->nomin_var<min) min = ptr_a->nomin_var;
      if(ptr_a->nomin_var>max){ max = ptr_a->nomin_var; len_max=2; }
     }
     for(i=0,ptr_d=ptr_c->d_ptr; i < ptr_c->num_dp; i++, ptr_d++)
     {
      if(ptr_d->type_par!=0 || ptr_d->nolog || ptr_d->type_com==0 || ptr_d->pasive ||
         (ptr_d->nom_var+1) > (MaxLenReq*(ii+1)) || (ptr_d->nom_var+1) < (MaxLenReq*ii))  continue;
      if(ptr_d->nom_var<min) min = ptr_d->nom_var;
      if(ptr_d->nom_var>max){ max = ptr_d->nom_var; len_max=1; }
     }
     if(max>=min)
     {
      if(glob->check_st)        kzgen|=0x8000;  // kztmp = 17;
      else if(glob->no_scan_DB) {kzgen=ptr_c->basaddr; kzgen|=0x6000; } // kztmp=0x85;
      else
      {
       kztmp=GetDB_CIF(ptr_c->nomport,ptr_c->vector,ptr_c->nom_ord+1,ptr_c->basaddr,MaxLenReq*ii,max-MaxLenReq*ii+len_max,&buffer);
//       eprintf(GRAY_,"ERROR TEST_2 %x",kztmp);
//       if(kztmp== -1 || kztmp== -2) {glob->no_scan_DB=1; kzgen|=0x0800; goto kz_end;}
       if(kztmp== -3 || kztmp== -4 || kztmp== 17) { kzgen|=0x8000; glob->check_st=1;}
       else if(kztmp==0x85) {kzgen=ptr_c->basaddr; kzgen|=0x6000; glob->no_scan_DB=1; }
       else if(kztmp==0x87) {kzgen=ptr_c->basaddr; kzgen|=0x4000; }
       else if(kztmp) { kzgen=kztmp; kzgen|=0x1000; }
      }
      for(i=0,ptr_a=ptr_c->a_ptr;i< ptr_c->num_ap;i++,ptr_a++)
      {
       if(ptr_a->nolog || ptr_a->pasive || (ptr_a->nomin_var+2) > (MaxLenReq*(ii+1)) || (ptr_a->nomin_var+2) < (MaxLenReq*ii)) continue;
       if(kztmp) {ptr_a->hard_err=1; continue;}
       if(ptr_a->type_mech==NO_REG || ptr_a->type_mech==M_INP)
       {
        val=*(word_s *)(buffer+ptr_a->nomin_var-MaxLenReq*ii);
        val=*(word_s *)revers((char *)&val,2)*K_S7;
        ptr_a->var_tech = valtec(ptr_a,val);
//        eprintf(GRAY_,"ANALOG:%d = %f (%d)",ptr_a->nomin_var,ptr_a->var_tech,ptr_a->nomin_var-MaxLenReq*ii);
       }
       ptr_a->hard_err = 0;
      }
      for(i=0,ptr_d=ptr_c->d_ptr;i< ptr_c->num_dp;i++,ptr_d++)
      {
       if(ptr_d->type_par!=0 || ptr_d->nolog || ptr_d->pasive ||
          (ptr_d->nom_var+1) > (MaxLenReq*(ii+1)) || (ptr_d->nom_var+1) < (MaxLenReq*ii)) continue;
       if(kztmp) {ptr_d->hard_err=1; continue;}
       if(ptr_d->type_com!=0)
       {
        tmp_b=1<<ptr_d->nom_vr2;
        if(buffer[ptr_d->nom_var-MaxLenReq*ii]&tmp_b) val=1; else val=0;
        if(val!=ptr_d->val_par || ptr_d->dif_par==1) ptr_d->dif_par=1; else ptr_d->dif_par=0;
        ptr_d->val_par=val;
//        eprintf(GRAY_,"DIGIT: %d = %d(%d)",ptr_d->nom_var,ptr_d->val_par,ptr_d->nom_var-MaxLenReq*ii);
#if (PROTOC)
        if(ptr_d->archive)
        {
         if(ptr_d->dif_par)
         {
          val=ptr_d->val_par;
          val<<=6; val|=ptr_c->nom_ord; val<<=9; val |=i; val |=0x1000;
          c_write_wpipe(event_chn, val);
         }
        }
#endif
       }
       ptr_d->hard_err=0;
      }
     }
    }
   }
//------------  ॣ஢ ---------------------------------
//   eprintf(GRAY_,"TEST IN REG %x",kztmp);
   if(kzgen&0x8000 /*kztmp == 17*/) goto kz_end;
   for(i=0,ptr_a=ptr_c->a_ptr; i < ptr_c->num_ap; i++, ptr_a++)
   {
    if(!(ptr_a->type_mech==NC || ptr_a->type_mech==NO) || ptr_a->nolog || ptr_a->pasive) continue;
    kztmp=GetDB_CIF(ptr_c->nomport,ptr_c->vector,ptr_c->nom_ord+1,ptr_a->nomin_var,0,76,&buffer);
//    eprintf(GRAY_,"ERROR TEST_REG %d = %x",ptr_a->nomin_var,kztmp);
//    if(kztmp== -1 || kztmp== -2) goto kz_end;
    if(kztmp==0x85) { kzgen=ptr_a->nomin_var; kzgen|=0x6000; kz_com(ptr_c->kz=kzgen,ptr_c); }
    else if(kztmp==0x87) { kzgen=ptr_a->nomin_var; kzgen|=0x4000; kz_com(ptr_c->kz=kzgen,ptr_c); }
    else if(kztmp) { kzgen=kztmp; kzgen|=0x1000; }
    if(!kztmp)
    {
     if(buffer[0]&0x02)      ptr_a->mod_cod=R_MAN;
     else if(buffer[1]&0x01) ptr_a->mod_cod=R_CAS;
     else                    ptr_a->mod_cod=R_AUTO;
     ptr_a->set_cod = *(float *)revers(buffer+6,4)*ADC_SC/100.0;
     ptr_a->out_cod = *(float *)revers(buffer+72,4)*ADC_SC/100.0;
     val=*(word_s *)revers(buffer+14,2)*K_S7;
     ptr_a->var_tech = valtec(ptr_a,val);

//     eprintf(GRAY_,"REG: %d = %f - %f - %d",ptr_a->nomin_var,ptr_a->set_cod,ptr_a->out_cod,ptr_a->var_tech);

    } else ptr_a->hard_err=1;
   }
   if(glob->last_kz==1) {if(GetStatContrCIF(ptr_c->nomport,ptr_c->nom_ord+1)==0) kzgen|=0x0800; /*kztmp= -6;*/ }
   else if(glob->last_time++ > 5)
   {glob->last_time=0; if(GetStatContrCIF(ptr_c->nomport,ptr_c->nom_ord+1)==0)   kzgen|=0x0800; /*kztmp= -6;*/ }
   if(kzgen&0x0800) glob->last_kz=1; else glob->last_kz=0;
  }
  kz_end: kz_com(ptr_c->kz=kzgen,ptr_c);
//------------
  if(yes_P5)time_virt[ptr_c->nom_ord] = takt_cpu() - takt_old;
//------------
  release_resource(ptr_c->port_rsc);       // ᢮.p-pp
 }
}


void enable_S7(void)
{
 int  i;
 TSK_glb_parm *gl_par;

 for(i=0;i<c_num;i++)
 {
  if(c_ptr[i].typcontr!=S7xx) continue;
  if(RegTaskForCIF(c_ptr[i].nomport,c_ptr[i].nom_ord+1)!=DRV_NO_ERROR ||
     RegTaskForCIF(c_ptr[i].nomport,(c_ptr[i].nom_ord+1)|0x80)!=DRV_NO_ERROR)
  { eprintf(RED_," 樠樨 CIF50"); c_ptr[i].period=0; }
  else
  {
   if(!glb_parm) {glb_parm=calloc(sizeof(TSK_glb_parm),1); glb_parm->n_contr=c_ptr[i].nom_ord;}
   else
   {
    gl_par=glb_parm;
    while(gl_par->next) gl_par=gl_par->next;
    gl_par->next=calloc(sizeof(TSK_glb_parm),1);
    gl_par->next->n_contr=c_ptr[i].nom_ord;
   }
  }
 }
}

void disable_S7(void)
{
 int  i;
 TSK_glb_parm *next = NULL;

 for(i=0;i<c_num;i++)
 {
  if(c_ptr[i].typcontr!=S7xx) continue;
  UnregTaskForCIF(c_ptr[i].nomport,c_ptr[i].nom_ord+1);
  UnregTaskForCIF(c_ptr[i].nomport,(c_ptr[i].nom_ord+1)|0x80);
 }
 for(;glb_parm;glb_parm=next){ next=glb_parm->next; free(glb_parm); }
}

void insert_S7(controller *ctr,int n_contr,char *Basa,int mode)
{
  word_s i;
  char str[256];
  analog *a_ptr;
  digit *d_ptr;

  if(mode==InsContr)
  {
   GetFieldItDbf(Basa,n_contr,"PORT",str);  ctr[n_contr].nomport  = atoi(str);
   GetFieldItDbf(Basa,n_contr,"ADRES",str); ctr[n_contr].basaddr  = atoi(str);
   GetFieldItDbf(Basa,n_contr,"VECT",str);  ctr[n_contr].vector   = atoi(str);
   GetFieldItDbf(Basa,n_contr,"LINE",str);  ctr[n_contr].IRQ_line = atoi(str);
  }
  if(mode==InsAnlog)
  {
   a_ptr=ctr[n_contr].a_ptr;
   for(i=0;i<GetCountItDbf(Basa);i++)
   {
    GetFieldItDbf(Basa,i,"OFFSET",str);  a_ptr[i].nomin_var=atoi(str);
    GetFieldItDbf(Basa,i,"TIP_ADD",str); a_ptr[i].type_var= atoi(str);
    a_ptr[i].hard_err = 1;
   }
  }
  if(mode==InsDigit)
  {
   d_ptr=ctr[n_contr].d_ptr;
   for(i=0;i<GetCountItDbf(Basa);i++)
   {
    GetFieldItDbf(Basa,i,"OFFSET",str); d_ptr[i].nom_var=atoi(str);
    GetFieldItDbf(Basa,i,"N_BIT",str);  d_ptr[i].nom_vr2=atoi(str);
    d_ptr[i].hard_err = 1;
   }
  }
}

//-------------------- ⠭ ⭮ ࠬ ----------------------------
int SetDigVal_S7(controller *ctr, digit *p_d,int val)
{
 char buffer[250],tmp_b;
 word_s kztmp,kzgen;
 TSK_glb_parm *glob;

 if(ctr->IRQ_line != 0)
 {
    if(p_d->val_par == val) return(0);
    p_d->dif_par = 1;
    p_d->val_pr2 = val;
    return(0);
 }

 kzgen=kztmp=0;
 if(p_d->pasive || !ctr->period)       kzgen=0;
 else
 {
  glob=glb_parm;
  while(glob && glob->n_contr!=ctr->nom_ord) glob=glob->next;
  if(!glob) kzgen|=0x1000; // kztmp=-5;
  else if(glob->check_st)   kzgen|=0x8000; //kztmp= 17;
  else if(glob->no_scan_DB) kzgen|=0x6000; //kztmp=0x85;
  else
  {
   request_resource(ctr->port_rsc,0L);     // 墠 p-p
   p_d->nolog=1;
   kztmp=GetDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,ctr->basaddr,p_d->nom_var,1,&buffer);
   kzgen=GetKZ(ctr,kztmp,ctr->basaddr);
   if(!kztmp)
   {
    tmp_b=1<<p_d->nom_vr2;
    if(val) buffer[0]=buffer[0]|tmp_b; else buffer[0]=buffer[0]&(~tmp_b);
    kztmp=PutDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,ctr->basaddr,p_d->nom_var,1,&buffer);
    kzgen=GetKZ(ctr,kztmp,ctr->basaddr);
   }
   p_d->nolog=0;
   release_resource(ctr->port_rsc);       // ᢮.p-pp
  }
 }
 if(!kztmp) p_d->val_par=val;

 kz_com(ctr->kz=kzgen,ctr);
 return(kztmp);
}

//--------------------  祭  ଠ IBM ---------------------
byte *revers(byte *buff, word_s len)
{
  word_s i;
  byte bt;

  for(i=0; i < len/2; i++) { bt=buff[i]; buff[i]=buff[len-1-i]; buff[len-1-i]=bt; }
  return buff;
}
//-------------------- ⠭  ࠬ ----------------------------
int SetAnalogVal_S7(controller *ctr, analog *p_a,int val)
{
 char buffer[250];
 word_s kztmp,kzgen,val_tmp;
 TSK_glb_parm *glob;

 if(ctr->IRQ_line != 0)
 {
    if(p_a->var_cod == val) return(0);
    p_a->dif_var = 1;
    p_a->dif_cod = val;
    return(0);
 }

 kzgen=kztmp=0;
 if(p_a->pasive || !ctr->period)       kzgen=0;
 else
 {
  glob=glb_parm;
  while(glob && glob->n_contr!=ctr->nom_ord) glob=glob->next;
  if(!glob)                 kzgen|=0x1000;
  else if(glob->check_st)   kzgen|=0x8000; //kztmp= 17;
  else if(glob->no_scan_DB) kzgen|=0x6000;
  else
  {
   request_resource(ctr->port_rsc,0L);     // 墠 p-p
   val_tmp=val/K_S7;
   buffer[1]=((char *)&val_tmp)[0];
   buffer[0]=((char *)&val_tmp)[1];
   kztmp=PutDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,ctr->basaddr,p_a->nomin_var,2,&buffer);
   kzgen=GetKZ(ctr,kztmp,ctr->basaddr);
   release_resource(ctr->port_rsc);       // ᢮.p-pp
  }
 }
 if(!kztmp) { p_a->var_cod=val; p_a->var_tech=valtec(p_a,p_a->var_cod); }
 kz_com(ctr->kz=kzgen,ctr);
 return(kztmp);
}

//-------------------- ⠭  ࠬ ----------------------------
word_s mode_S7(controller *ctr, analog *p_a, word_s val)
{
 char buffer[250];
 word_s kztmp,kzgen;
 TSK_glb_parm *glob;

 kzgen=kztmp=0;
 if(p_a->pasive || !ctr->period)       kzgen=0;
 else
 {
  glob=glb_parm;
  while(glob && glob->n_contr!=ctr->nom_ord) glob=glob->next;
  if(!glob)               kzgen|=0x1000;
  else if(glob->check_st) kzgen|=0x8000; //kztmp= 17;
  else
  {
   request_resource(ctr->port_rsc,0L);     // 墠 p-p
   kztmp=GetDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,p_a->nomin_var,0,2,&buffer);
   kzgen=GetKZ(ctr,kztmp,p_a->nomin_var);
   if(!kztmp)
   {
    if(val==R_MAN)  { buffer[0]|=0x02;    buffer[1]&=(~0x01); }
    if(val==R_CAS)  { buffer[1]|=0x01;    buffer[0]&=(~0x02); }
    if(val==R_AUTO) { buffer[0]&=(~0x02); buffer[1]&=(~0x01); }
    kztmp=PutDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,p_a->nomin_var,0,2,&buffer);
    kzgen=GetKZ(ctr,kztmp,p_a->nomin_var);
   }
   release_resource(ctr->port_rsc);       // ᢮.p-pp
  }
 }

 kz_com(ctr->kz=kzgen,ctr);
 return(kztmp);
}

//-------------------- ⠭ 祭 ॣ ----------------------------
word_s so_S7(controller *ctr, analog *p_a, word_s val)
{
 char buffer[250];
 word_s kzgen,kztmp,offs;
 TSK_glb_parm *glob;

 kzgen=kztmp=0;
 if(p_a->pasive || !ctr->period)       kzgen=0;
 else
 {
  glob=glb_parm;
  while(glob && glob->n_contr!=ctr->nom_ord) glob=glob->next;
  if(!glob)                kzgen|=0x1000;
  else if(glob->check_st)  kzgen|=0x8000;  //kztmp= 17;
  else
  {
   request_resource(ctr->port_rsc,0L);     // 墠 p-p
   if(val==1)
   { *(float *)(buffer)=100.0*p_a->set_cod/ADC_SC; revers(buffer,4); offs=6; }   //SP
   if(val==2)
   { *(float *)(buffer)=100.0*p_a->out_cod/ADC_SC; revers(buffer,4); offs=16; }  //OUT in Manual
   kztmp=PutDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,p_a->nomin_var,offs,4,&buffer);
   kzgen=GetKZ(ctr,kztmp,p_a->nomin_var);
   release_resource(ctr->port_rsc);       // ᢮.p-pp
  }
 }

 kz_com(ctr->kz=kzgen,ctr);
 return(kztmp);
}

//-- 㭪 ࠡ⪨ ࠢ ⢨ ।⢥   ஫ ---------------
int so_contr_dir_S7(controller *ctr, analog *p_a, word_s key)
{
 char buffer[250];
 word_s kzgen,kztmp,offs;
 TSK_glb_parm *glob;

 kzgen=kztmp=0;
 if(p_a->type_var!=PM)             return(0);
 if(p_a->pasive || !ctr->period)   return(1);
 else
 {
  glob=glb_parm;
  while(glob && glob->n_contr!=ctr->nom_ord) glob=glob->next;
  if(!glob)                kzgen|=0x1000;
  else if(glob->check_st)  kzgen|=0x8000;  //kztmp= 17;
  else
  {
   request_resource(ctr->port_rsc,0L);     // 墠 p-p
   offs=16;                                // offs Manual
   if(key==MORE)  *(float *)(buffer)= 20.; if(key==LESS)  *(float *)(buffer)=-20.;
   if(key==QMORE) *(float *)(buffer)= 60.; if(key==QLESS) *(float *)(buffer)=-60.;
   revers(buffer,4);
   kztmp=PutDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,p_a->nomin_var,offs,4,&buffer);
   kzgen=GetKZ(ctr,kztmp,p_a->nomin_var);
   release_resource(ctr->port_rsc);       // ᢮.p-pp
  }
 }

// eprintf(GRAY_,"TEST PM %x",kztmp);

 kz_com(ctr->kz=kzgen,ctr);
 return(1);
}

//-------------------- 祭   祭 樥⮢ ---------------------------
rec_koeff st_kf_S7_PM[15] =
{
 { " =","%7.2f",  5, 36,  -100.0,  100.0, 89,14, 20,0.0,'R'},
 { " =","%7.2f",  6, 36,     0.0, 9999.0, 89,14, 24,0.0,'T'},
 { " =","%7.2f",  7, 36,     0.0, 9999.0, 89,14, 28,0.0,'T'},
 { " =","%7.2f",  8, 36,     0.0, 9999.0, 89,14, 32,0.0,'T'},
 { "1 =","%7.2f",  9, 36,     0.0,  100.0, 89,14, 44,0.0,'R'},
 { "2 =","%7.2f", 10, 36,     0.0,  100.0, 89,14, 40,0.0,'R'},
 { "Zn =","%7.2f", 11, 36,     0.0,  100.0, 89,14, 36,0.0,'R'},
 { "Rf =","%7.2f",  5, 50,   -10.0,   10.0, 89,14,100,0.0,'R'},
 { "T=","%7.2f",  6, 50,     0.0,  100.0, 89,14,104,0.0,'T'},
 { "T=","%7.2f",  7, 50,     0.0,  100.0, 89,14,108,0.0,'T'},
 { "1 =","%7.2f",  8, 50,   -10.0,   10.0, 89,14,112,0.0,'R'},
 { "2 =","%7.2f",  9, 50,   -10.0,   10.0, 89,14,116,0.0,'R'},
 { "3 =","%7.2f", 10, 50,   -10.0,   10.0, 89,14,120,0.0,'R'},
 { "4 =","%7.2f", 11, 50,   -10.0,   10.0, 89,14,124,0.0,'R'}
};

rec_koeff st_kf_S7_SM[15] =
{
 { " =","%7.2f",  5, 36,  -100.0,  100.0, 89,14, 20,0.0,'R'},
 { " =","%7.2f",  6, 36,     0.0, 9999.0, 89,14, 24,0.0,'T'},
 { " =","%7.2f",  7, 36,     0.0, 9999.0, 89,14, 28,0.0,'T'},
 { " =","%7.2f",  8, 36,     0.0, 9999.0, 89,14, 32,0.0,'T'},
 { "1 =","%7.2f",  9, 36,     0.0,  100.0, 89,14, 44,0.0,'R'},
 { "2 =","%7.2f", 10, 36,     0.0,  100.0, 89,14, 40,0.0,'R'},
 { "Zn =","%7.2f", 11, 36,     0.0,  100.0, 89,14, 36,0.0,'R'},
 { "1 =","%7.2f",  5, 50,   -10.0,   10.0, 89,14,112,0.0,'R'},
 { "2 =","%7.2f",  6, 50,   -10.0,   10.0, 89,14,116,0.0,'R'},
 { "3 =","%7.2f",  7, 50,   -10.0,   10.0, 89,14,120,0.0,'R'},
 { "4 =","%7.2f",  8, 50,   -10.0,   10.0, 89,14,124,0.0,'R'}
};

rec_koeff st_kf_S7_STD[15] =
{
 { " =","%7.2f",  5, 36,  -100.0,  100.0, 89,14, 20,0.0,'R'},
 { " =","%7.2f",  6, 36,     0.0, 9999.0, 89,14, 24,0.0,'T'},
 { " =","%7.2f",  7, 36,     0.0, 9999.0, 89,14, 28,0.0,'T'},
 { " =","%7.2f",  8, 36,     0.0, 9999.0, 89,14, 32,0.0,'T'},
 { "1 =","%7.2f",  9, 36,     0.0,  100.0, 89,14, 44,0.0,'R'},
 { "2 =","%7.2f", 10, 36,     0.0,  100.0, 89,14, 40,0.0,'R'},
 { "Zn =","%7.2f", 11, 36,     0.0,  100.0, 89,14, 36,0.0,'R'}
};


int get_kfS7(controller *ctr, analog *p_a,void **koef)
{
 int          i,n_koeff,max=0,min=100000;
 char         buffer[250];
 word_s       kzgen,kztmp;
 TSK_glb_parm *glob;
 rec_koeff    *t_st_koef;

 n_koeff=0;
 if(p_a->type_var==SM)       {t_st_koef=st_kf_S7_SM;  n_koeff=sizeof(st_kf_S7_SM)/sizeof(rec_koeff); }
 else if(p_a->type_var==PM)  {t_st_koef=st_kf_S7_PM;  n_koeff=sizeof(st_kf_S7_PM)/sizeof(rec_koeff); }
 else                        {t_st_koef=st_kf_S7_STD; n_koeff=sizeof(st_kf_S7_STD)/sizeof(rec_koeff); }

 kztmp=kzgen=0;
 if(p_a->pasive || !ctr->period)       kzgen=0;
 else
 {
  glob=glb_parm;
  while(glob && glob->n_contr!=ctr->nom_ord) glob=glob->next;
  if(!glob)                 kzgen|=0x1000;
  else if(glob->check_st)   kzgen|=0x8000;  //kztmp= 17;
  else
  {
   request_resource(ctr->port_rsc,0L);     // 墠 p-p
   for(i=0; i < n_koeff; i++)
   {
    if(t_st_koef[i].index < min) min = t_st_koef[i].index;
    if(t_st_koef[i].index > max) max = t_st_koef[i].index;
   }
   if(max>=min)
   {
    kztmp=GetDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,p_a->nomin_var,min,max-min+4,&buffer);
    kzgen=GetKZ(ctr,kztmp,p_a->nomin_var);
    for(i=0; i < n_koeff; i++)
    {
     if(t_st_koef[i].tip_kf=='R') t_st_koef[i].znach= *(float *)revers(buffer+t_st_koef[i].index-min,4);
     if(t_st_koef[i].tip_kf=='T'){ t_st_koef[i].znach= *(long *)revers(buffer+t_st_koef[i].index-min,4); t_st_koef[i].znach/=1000.; }

     if(t_st_koef[i].znach>t_st_koef[i].max) t_st_koef[i].znach=t_st_koef[i].max;
     if(t_st_koef[i].znach<t_st_koef[i].min) t_st_koef[i].znach=t_st_koef[i].min;
    }
   }
   release_resource(ctr->port_rsc);       // ᢮.p-pp
  }
 }

 kz_com(ctr->kz=kzgen,ctr);
 *koef=t_st_koef;
 return(n_koeff);
}
//-------------------- ⠭ 祭 樥 ---------------------------
int set_kfS7(controller *ctr, analog *p_a, word_s nom_kf, float valk)
{
 char         buffer[250];
 word_s       kzgen,kztmp,len;
 TSK_glb_parm *glob;
 rec_koeff    *t_st_koef;

 if(p_a->type_var==SM)      t_st_koef = st_kf_S7_SM;
 else if(p_a->type_var==PM) t_st_koef = st_kf_S7_PM;
 else                       t_st_koef = st_kf_S7_STD;

 kzgen=kztmp=0;
 if(p_a->pasive || !ctr->period)       kzgen=0;
 else
 {
  glob=glb_parm;
  while(glob && glob->n_contr!=ctr->nom_ord) glob=glob->next;
  if(!glob)                 kzgen|=0x1000;
  else if(glob->check_st)   kzgen|=0x8000; //kztmp= 17;
  else
  {
   request_resource(ctr->port_rsc,0L);     // 墠 p-p
   if(t_st_koef[nom_kf].tip_kf=='R') {*(float *)(buffer)=t_st_koef[nom_kf].znach; revers(buffer,4); len=4; }
   if(t_st_koef[nom_kf].tip_kf=='T') {*(long *)(buffer)=(t_st_koef[nom_kf].znach*1000.); revers(buffer,4); len=4; }
   kztmp=PutDB_CIF(ctr->nomport,ctr->vector,(ctr->nom_ord+1)|0x80,p_a->nomin_var,t_st_koef[nom_kf].index,len,&buffer);
   kzgen=GetKZ(ctr,kztmp,p_a->nomin_var);
   release_resource(ctr->port_rsc);       // ᢮.p-pp
  }
 }
// eprintf(GRAY_,"ERROR_KF_SET %d TEST %x",p_a->nomin_var,kztmp);

 kz_com(ctr->kz=kzgen,ctr);
 return(kztmp);
}

//祭 ଠ樨  ⥪饬 ॣ  ஫
int Get_info_contrS7(controller *ctr, analog *p_a,int n_mess,rec_info_reg *info_reg)
{
 if(n_mess==0)
 {info_reg->color=CYAN_; info_reg->str=4; info_reg->col=2;
  if(p_a->type_var==SM)      sprintf(info_reg->string,", ⨯ SM. : %d (DB)",p_a->nomin_var);
  else if(p_a->type_var==PM) sprintf(info_reg->string,", ⨯ PM. : %d (DB)",p_a->nomin_var);
  else                       sprintf(info_reg->string,", ⨯ STD. : %d (DB)",p_a->nomin_var);
 }
 else if(n_mess==1)
 {info_reg->color=WHITE_; info_reg->str=6; info_reg->col=2;
  sprintf(info_reg->string,"஫ S7_x: %d",ctr->nomcontr);
 }
 else return(-1);
 return(0);
}


int GetKZ(controller *ctr,word_s kztmp,word param)
{
 word_s kzgen=0;

 if(kztmp== -3 || kztmp== -4 || kztmp== 17 ) kzgen|=0x8000;
 else if(kztmp==0x85) { kzgen=param; kzgen|=0x6000;}
 else if(kztmp==0x87) { kzgen=param; kzgen|=0x4000;}
 else if(kztmp) { kzgen=kztmp; kzgen|=0x1000; }

 return(kzgen);
}

//-------------- 뤠 訡   ஫ ----------------------
word_s kz_mesage_S7(controller *pc,word_s kz,word_s chn,word_s kz_old)
{
 char *str;

 // eprintf(RED_,"ERROR_KZ1 TEST %x - %x",kz,kz_old);

 if(pc->nom_ord!=chn || kz_old!= kz)
 {
  bar_(0,280,337,559,346);
  if(kz&0x8000)
  {
    str="pp %d:   ";
    eprintf(RED_,str,pc->nomcontr);
  }
  else if(kz&0x4000)
  {
   if(kz&0x2000)
   {
     str=" DB %d   %d";
     eprintf(RED_,str,kz&0x07FF,pc->nomcontr);
   }
   else
   {
     str=" ᬥ饭  DB %d . %d";
     eprintf(RED_,str,kz&0x07FF,pc->nomcontr);
   }
  }
  else if(kz&0x1000)
  {
    if( (kz&0x07FF) == 0x02)      eprintf(RED_," ᮢ . %d !",pc->nomcontr);
    else if( (kz&0x07FF) == 0x39) eprintf(RED_,". %d  ॠ  !",pc->nomcontr);
    else                          eprintf(RED_,"⭠ 訡 %xh, . %d",kz&0x07FF,pc->nomcontr);
  }
  else if(kz&0x0800)
  {
    str="஫ %d ⠭!";
    eprintf(RED_,str,pc->nomcontr); }
  }
  return(pc->nom_ord);
}

//-------------- ⥫쭠 ଠ  ࠬ ----------------
void ext_help_S7(byte tip,word_s nscr)
{
 if(tip == ANALOG)
  gprintf(HELP_L,60,";CP%d;ST%d;DB%d;A%d",p_c[nscr]->nomport,p_c[nscr]->vector,p_c[nscr]->basaddr,p_a[nscr]->nomin_var);
 else
  gprintf(HELP_L,14,";CP%d;ST%d;DB%d;D%d\.%d",p_c[nscr]->nomport,p_c[nscr]->vector,p_c[nscr]->basaddr,p_d[nscr]->nom_var,p_d[nscr]->nom_vr2);
}

