/*
   SIO_AD8.H - TCtask - Serial I/O interface routine definitions.

   V1.1   T.Wagner
   V1.2   TECON Ltd.
   V1.3   "DIYA" Co.
*/

#define XON          0x11
#define XOFF          0x13

/* Parity values for "v24_change_parity" */

#define PAR_NONE  0x00
#define PAR_EVEN  0x18
#define PAR_ODD   0x08
#define PAR_MARK  0x28
#define PAR_SPACE 0x38

/* Parity values for "ad8_change_parity" */

#define NONE  0x00
#define EVEN  0x30
#define ODD   0x10

/* Modem control bits for "v24_watch_modem" */

#define CTS          0x10
#define DSR          0x20
#define RI          0x40
#define CD          0x80

/* Values for "v24_protocol" */

#define XONXOFF   0x01
#define RTSCTS          0x02

/* Internal structures */

typedef struct s_port_data *portptr;
typedef struct s_sio_datarec *sioptr;

typedef struct s_port_data {
                           portptr     next;        /* Next defined port */
                           word_s      pnum;        /* Internal Port ID */
                           sioptr      sio;        /* SIO control block */
                           word_s      base;        /* Port base */
                           byte        irq;        /* IRQ level */
                           byte        vector;        /* Interrupt vector number */
                           } port_data;


typedef struct s_sio_datarec {
             sioptr   next;             /* Next link for shared IRQs */
             farptr   savvect;       /* Interrupt vector save location */
             portptr  port;             /* Port descriptor pointer */
             word_s   port_base;     /* Port base I/O address */
             word_s   r_xoff;             /* Receive disable (XOFF sent) */
             word_s   t_xoff;             /* Transmit disable (XOFF received) */
             word_s   xoff_threshold; /* Pipe free threshold for XOFF */
             word_s   xon_threshold; /* Pipe free threshold for XON */
             byte     clcontrol;     /* Current line control reg */
             byte     cmodcontrol;   /* Current modem control reg */
             byte     irqbit;             /* IRQ-Bit for this port */
             byte     civect;             /* Interrupt Vector for this port */
             byte     modstat;             /* Current modem status */
             byte     wait_xmit;     /* Transmit delayed */
             byte     xmit_pending;  /* Transmit in progress */
             byte     rtsoff;             /* RTS turned off by protocol */
             byte     overrun;             /* Pipe full on receive */
             byte     modem_flags;   /* Transmit enable modem flags */
             byte     flags;             /* Protocol flags */
             byte     save_lcon;     /* Previous line control value */
             byte     save_mcon;     /* Previous modem control value */
             byte     save_inten;    /* Previous interrupt control value */
             byte     save_irq;      /* Previous interrupt bit value */
             byte     save_bd1;      /* Previous baud rate lower byte */
             byte     save_bd2;      /* Previous baud rate upper byte */
             byte     modem_off;     /* ਧ 몫. 譥  */
             pipe     rcv_pipe;      /* Received characters */
             pipe     xmit_pipe;     /* Transmit pipe */
             char     *xmit_buf;     /* Transmit buffer  for  ad8 */
             word     len_xmit;      /* Lenth transmit data for ad8 */

           } sio_datarec;


/* function prototypes */

extern word_s v24_define_port (word_s base, byte irq, byte vector);

extern sioptr v24_install (word_s port, word_s init,
                               nearptr rcvbuf, word rcvsize,
                               nearptr xmitbuf, word xmitsize);
extern void v24_remove (sioptr sio, word_s restore);
extern void v24_remove_all (void);

extern void v24_change_rts (sioptr sio, word_s on);
extern void v24_change_dtr (sioptr sio, word_s on);
extern void v24_change_baud (sioptr sio, long rate);
extern void v24_change_parity (sioptr sio, word_s par);
extern void v24_change_wordlength (sioptr sio, word_s len);
extern void v24_change_stopbits (sioptr sio, word_s n);
extern void v24_watch_modem (sioptr sio, byte flags);
extern void v24_protocol (sioptr sio, word_s prot,
                              word offthresh, word onthresh);

extern word_s v24_send (sioptr sio, byte ch, dword timeout);
extern word_s v24_receive (sioptr sio, dword timeout);
extern word_s v24_overrun (sioptr sio);
extern word_s v24_check (sioptr sio);
extern word_s v24_modem_status (sioptr sio);
extern word_s v24_complete (sioptr sio);
extern word_s v24_wait_complete (sioptr sio, dword timeout);


extern word_s ad8_define_port (word_s base, byte irq, byte vector);
extern sioptr ad8_install (word_s port, nearptr rcvbuf, word rcvsize);
extern void ad8_remove (sioptr sio, word_s restore);
extern void ad8_remove_all (void);

extern void ad8_change_baud (sioptr sio, word_s rate);
extern void ad8_change_mode(sioptr sio, word_s len, word_s par, word_s n);

extern void ad8_send (sioptr sio, char *buf, word len);
extern word_s ad8_receive (sioptr sio, dword timeout);
extern word_s ad8_check (sioptr sio);
