// defines for PCI interrupt
#define PCI_INT                 0x1A // BIOS-Interrupt
#define PCI_FUNCTION_ID         0xB1 // AH: ID for PCI-Functions
#define PCI_BIOS_PRESENT        0x01 // AL: check if BIOS is present
#define PCI_FIND_DEVICE         0x02 // AL: find device
#define PCI_FIND_CLASS_CODE     0x03 // AL: find class_code
#define PCI_READ_CONFIG_BYTE    0x08 // AL: read configuration (byte)
#define PCI_READ_CONFIG_WORD    0x09 // AL: read configuration (word)
#define PCI_READ_CONFIG_DWORD   0x0a // AL: read configuration (long)
#define PCI_WRITE_CONFIG_BYTE   0x0b // AL: read configuration (byte)
#define PCI_WRITE_CONFIG_WORD   0x0c // AL: read configuration (word)
#define PCI_WRITE_CONFIG_DWORD  0x0d // AL: read configuration (long)

#define PCI_BASE_ADDRESS_IO_MASK (~0x03UL)

extern int pci_bios_available(void);
extern int make_pci_interrupt(union REGS *pregs);
extern int pci_dev_find(int dev_index, unsigned int *stat, unsigned long vendor_id, unsigned long device_id);
extern int pci_class_code_find(int dev_index, unsigned int *stat, unsigned long class_code);
extern int PCIReadConfRegByte(int pci_dev_and_funct,int pci_bus, unsigned int config_reg, unsigned char *phy_address_ptr);
extern int PCIReadConfRegWord(int pci_dev_and_funct,int pci_bus, unsigned int config_reg, unsigned short *phy_address_ptr);
extern int PCIReadConfRegDword(int pci_dev_and_funct,int pci_bus, unsigned int config_reg, unsigned long *phy_address_ptr);
extern int PCIWriteConfRegByte(int pci_dev_and_funct,int pci_bus, unsigned int config_reg, unsigned char param);
extern int PCIWriteConfRegWord(int pci_dev_and_funct,int pci_bus, unsigned int config_reg, unsigned short param);
extern int PCIWriteConfRegDword(int pci_dev_and_funct,int pci_bus, unsigned int config_reg, unsigned long param);


