/*
   BITBUS.H - TCtask - Bitbus inteface type definitions and global routine
                                          prototypes.

   V1.2  TECON Ltd.

   Changing requires recompile of tcbitbus.c.
*/
#define BITBUS_MSG_LEN_MAX      20
#define BITBUS_HEADER_LEN       7
#define RAC_CODE_MAX            0x12
#define RAC_CODE_GAP            0x10

#define DEST_EXT_MSK            0x20
#define SRC_EXT_MSK             0x40
#define REPLY_FLAG              0x80

#define BITBUS_COM_TIMEOUT      10L
#define BITBUS_COM_BAUD         9600L
#define BITBUS_TCX_COUNTOUT     100

#define TFNF    0x01                        /* Transmit Fifo Not Full (if 0) */
#define RFNE    0x10                        /* Receive Fifo Not Empty (if 0) */
#define RCMD    0x20                        /* Receive CoMmanD (if 0)        */
#define DATA    port_base+0
#define COMMAND port_base+2
#define STATUS  port_base+4
#define RESET   port_base+6


typedef struct {
                                byte link[2];
                                byte length;
                                byte flags;
                                byte node;
                                byte source_dest;
                                byte cmd_stat;
                                byte data[BITBUS_MSG_LEN_MAX - BITBUS_HEADER_LEN];
                                } bitbus_msg;
typedef bitbus_msg *bitbus_msgptr;

extern word_s bitbus_com_install (word_s port);
extern word_s bitbus_com_flush (void);
extern word_s bitbus_com_send (bitbus_msg *msg);
extern word_s bitbus_com_wait (bitbus_msg *msg, dword timeout);

extern word_s bitbus_tcx_install (word port);
extern word_s bitbus_tcx_flush (void);
extern word_s bitbus_tcx_send (bitbus_msg *msg);
extern word_s bitbus_tcx_wait (bitbus_msg *msg, dword timeout);

/* RAC command codes & lengths */
#define RESET_STATION       0x00
#define CREATE_TASK         0x01
#define DELETE_TASK         0x02
#define GET_FUNCTION_IDS    0x03
#define RAC_PROTECT         0x04
#define EXT_IO_READ         0x05
#define EXT_IO_WRITE        0x06
#define EXT_IO_UPDATE       0x07
#define EXT_UPLOAD          0x08
#define EXT_DNLOAD          0x09
#define EXT_IO_OR           0x0a
#define EXT_IO_AND          0x0b
#define EXT_IO_XOR          0x0c
#define INT_WRITE           0x0d
#define INT_READ            0x0e
#define NODE_INFO           0x0f
#define UPLOAD_CODE         0x11
#define DNLOAD_CODE         0x12

#define RESET_STATION_LEN_MAX       8
#define CREATE_TASK_LEN_MAX         9
#define DELETE_TASK_LEN_MAX         8
#define GET_FUNCTION_IDS_LEN_MAX    15
#define RAC_PROTECT_LEN_MAX         8
#define EXT_IO_READ_LEN_MAX         19
#define EXT_IO_WRITE_LEN_MAX        19
#define EXT_IO_UPDATE_LEN_MAX       19
#define EXT_UPLOAD_LEN_MAX          20
#define EXT_DNLOAD_LEN_MAX          20
#define EXT_IO_OR_LEN_MAX           19
#define EXT_IO_AND_LEN_MAX          19
#define EXT_IO_XOR_LEN_MAX          19
#define INT_WRITE_LEN_MAX           19
#define INT_READ_LEN_MAX            19
#define NODE_INFO_LEN_MAX           20
#define UPLOAD_CODE_LEN_MAX         20
#define DNLOAD_CODE_LEN_MAX         20

#define RESET_STATION_LEN_MIN       8
#define CREATE_TASK_LEN_MIN         9
#define DELETE_TASK_LEN_MIN         8
#define GET_FUNCTION_IDS_LEN_MIN    8
#define RAC_PROTECT_LEN_MIN         8
#define EXT_IO_READ_LEN_MIN         9
#define EXT_IO_WRITE_LEN_MIN        9
#define EXT_IO_UPDATE_LEN_MIN       9
#define EXT_UPLOAD_LEN_MIN          10
#define EXT_DNLOAD_LEN_MIN          10
#define EXT_IO_OR_LEN_MIN           9
#define EXT_IO_AND_LEN_MIN          9
#define EXT_IO_XOR_LEN_MIN          9
#define INT_WRITE_LEN_MIN           9
#define INT_READ_LEN_MIN            9
#define NODE_INFO_LEN_MIN           20
#define UPLOAD_CODE_LEN_MIN         10
#define DNLOAD_CODE_LEN_MIN         10

/* RAC status codes */
#define E_SERVICE_OK            0x00
#define E_PROTOCOL_ERROR        0x91
#define E_NO_DESTINATION_DEVICE 0x93
#define E_ACCESS_PROTECTED      0x94
#define E_RAC_PROTECTED         0x95
#define E_UNKNOWN_RAC_COMMAND   0x96

/* OC51 status codes */
#define E_OK                    0x00
#define E_EXIST                 0x80
#define E_MAX_TASKS             0x81
#define E_REGS                  0x82
#define E_FID                   0x83
#define E_BUFFERS               0x84

