;
;       TCtask - BIOS INT 15 interrupt handler (IBM AT specific)
;
;       V1.1    T.Wagner
;       V1.2    TECON Ltd.
;
        name    tcbios
;        .model  large
;
        public  _tsk_install_bios
        public  _tsk_remove_bios
;
        include tsk.mac

pint=15h

        .data?
;
        extrn   _ticks_per_sec: dword
;
floppy  flag    <>
fdisk   flag    <>
kbd     flag    <>
;
        .data
;
flag_tab        label   dword
        dd      offset fdisk
        dd      offset floppy
        dd      offset kbd
;
        IF      TSK_NAMEPAR
fflname db      "FLOPPY",0
ffdname db      "HARDDISK",0
fkbname db      "KBDPOST",0
        ENDIF
;
        .code
;
        extrn   _clear_flag_wait_set :near
        extrn   _set_flag            :near
        extrn   _create_flag         :near
        extrn   _delete_flag         :near
        extrn   t_delay_             :near
;
post_save       label   dword           ; in CSEG to allow addressing
psofs           dd      ?
psseg           dw      ?
;
;----------------------------------------------------------------------
;
;       interrupt handler
;
bios_int        proc
        pushfd
        sti
        cmp     ah,90h                  ; WAIT
        jb      bios_pass
        cmp     ah,91h                  ; POST
        ja      bios_pass
        cmp     al,2                    ; fdisk/floppy/keyboard
        jbe     process_bios
        cmp     ah,91h
        je      bios_pass
        cmp     al,0fdh                 ; floppy motor
        jb      bios_pass
        cmp     al,0feh                 ; printer
        jbe     process_bios
;
bios_pass:
        popfd
        jmp     fword ptr cs:post_save
;
process_bios:
        popfd
        sti
        push    es
        push    ds
        push    dx
        push    cx
        push    bx
        push    ax
        mov     bx,cs               ; SEG dgroup  ;"++"
        mov     ds,bx
        mov     es,bx
;
        cmp     al,2
        jbe     flag_ops
;
        cmp     al,0fdh
        je      wait_motor
;
;       wait for printer ready.
;       delay for some ticks, then check printer.
;       CAUTION: this assumes the BIOS is *truly* AT compatible,
;                with the printer port address in DX on entry to INT15.
;
wait_prn:
        mov     eax,3
        call    t_delay_
        in      al,dx
        test    al,80h
        jz      wait_prn
        stc
;
bios_ret:
        pop     ax
        pop     bx
        pop     cx
        pop     dx
        pop     ds
        pop     es
        ret     2
;
;       Wait for diskette motor start (1 sec.)
;
wait_motor:
        mov     eax,_ticks_per_sec
        call    t_delay_
        stc
        jmp     bios_ret
;
;       Floppy/Fdisk/Keyboard wait/post
;
flag_ops:
        xor     bh,bh
        mov     bl,al
        add     bx,bx
        mov     bx,flag_tab[bx]
        cmp     ah,90h
        je      fl_wait
        push    ds
        push    bx
        call    _set_flag
        add     sp,4
        clc
        jmp     bios_ret
;
fl_wait:
        xor     dx,dx
        cmp     al,2
        je      fl_dowait
        mov     dx,_ticks_per_sec
        add     dx,dx
        cmp     al,1
        je      fl_dowait
        mov     cx,dx
        add     dx,cx
        add     dx,cx
fl_dowait:
        xor     ax,ax
        push    ax
        push    dx
        push    ds
        push    bx
        call    _clear_flag_wait_set
        add     sp,8
        cmp     ax,0
        je      bios_ret
        stc
        jmp     bios_ret
;
bios_int       endp
;
;------------------------------------------------------------------------
;
;       void far _tsk_remove_bios (void)
;
;       This routine un-installs the int handler.
;
_tsk_remove_bios    proc
;
        cli

        mov     bl,pint
        mov     ax,205h                  ;⠭  8  DS:EDX
        mov     edx, psofs
        mov     cx, psseg
        int     31h
        sti
;
        mov     eax,offset floppy
        push    eax
        call    _delete_flag
        add     sp,4
;
        mov     eax,offset fdisk
        push    eax
        call    _delete_flag
        add     sp,4
;
        mov     eax,offset kbd
        push    eax
        call    _delete_flag
        add     sp,4
;
        ret
;
_tsk_remove_bios        endp
;
;----------------------------------------------------------------------
;
;       void far _tsk_install_bios (void)
;
;       This routine installs the int handler.
;
_tsk_install_bios       proc
;
        IF      TSK_NAMEPAR
        mov     eax,offset fflname
        push    eax
        ENDIF
        mov     eax,offset floppy
        push    eax
        call    _create_flag
        IF      TSK_NAMEPAR
        add     sp,8
        ELSE
        add     sp,4
        ENDIF
;
        IF      TSK_NAMEPAR
        mov     eax,offset ffdname
        push    eax
        ENDIF
        mov     eax,offset fdisk
        push    eax
        call    _create_flag
        IF      TSK_NAMEPAR
        add     sp,8
        ELSE
        add     sp,4
        ENDIF
;
        IF      TSK_NAMEPAR
        mov     eax,offset fkbname
        push    eax
        ENDIF
        mov     eax,offset kbd
        push    eax
        call    _create_flag
        IF      TSK_NAMEPAR
        add     sp,8
        ELSE
        add     sp,4
        ENDIF

        mov     bl,pint
        mov     ax,204h                 ;⥭  뢠 8 = es:ebx
        int     31h
        mov     psofs,edx
        mov     psseg,cx

        cli

        mov     bl,pint
        mov     ax,205h                  ;⠭  8  DS:EDX
        mov     edx,offset bios_int
        mov     cx,cs
        int     31h

        sti
        ret
;
_tsk_install_bios       endp
;
        end

