/*
   bgu.H - TCtask - Serial I/O interface routine definitions.

   V1.1   T.Wagner
   V1.2   TECON Ltd.
   V1.3   "DIYA" Co.
*/

/* Parity values for "bgu_change_parity" */

#define PAR_NONE  0x00
#define PAR_EVEN  0x30
#define PAR_ODD   0x10

/* Internal structures */

typedef struct s_port_data *portptr;
typedef struct s_sio_datarec *sioptr;

typedef struct s_port_data {
                           portptr     next;    /* Next defined port */
                           word_s      pnum;    /* Internal Port ID */
                           sioptr      sio;     /* SIO control block */
                           word_s      base;    /* Port base */
                           byte        irq;     /* IRQ level */
                           byte        vector;  /* Interrupt vector number */
                           } port_data;

typedef struct s_sio_datarec {

               sioptr   next;          /* Next link for shared IRQs */
               nearptr   savvect;       /* Interrupt vector save location */
               portptr  port;          /* Port descriptor pointer */
               word_s   port_base;     /* Port base I/O address */
               byte     clcontrol;     /* Current line control reg */
               byte     irqbit;        /* IRQ-Bit for this port */
               byte     civect;        /* Interrupt Vector for this port */
               byte     xmit_pending;  /* Transmit in progress */
                   byte     save_irq;      /* Previous interrupt bit value */
                   char *xmit_buf;     /* Transmit buffer              */
                   pipe     rcv_pipe;      /* Received characters */

               } sio_datarec;


/* function prototypes */

extern word_s bgu_define_port (word_s base, byte irq, byte vector);
extern sioptr bgu_install (word_s port, nearptr rcvbuf, word rcvsize);
extern void bgu_remove (sioptr sio, word_s restore);
extern void bgu_remove_all (void);

extern void bgu_change_baud (sioptr sio, long rate);
extern void bgu_change_parity (sioptr sio, word_s par);
extern void bgu_change_wordlength (sioptr sio, word_s len);
extern void bgu_change_stopbits (sioptr sio, word_s n);

extern void bgu_send (sioptr sio, char *buf, byte len);
extern word_s bgu_receive (sioptr sio, dword timeout);
extern word_s bgu_check (sioptr sio);
