/*   MPO8.H - TCtask-䥩   MPO8                       */

#define P_0  0x00         /*  ஫ */
#define P_1  0x18         /* ஫  ⭮ */
#define P_2  0x08         /* ஫  ⭮ */

typedef struct irq_data *irqptr;
typedef struct chn_data *chnptr;

struct irq_data {
  chnptr  pchn;       /* 㪠.  砫 ᯨ᪠    IRQ */
  nearptr  savvect;    /*  ண ࠡ稪 뢠 */
  word_s  base0;      /*    */
  byte    irqbit;     /* IRQ-  権  ᪮ */
  byte    save_irq;   /* ஥ 祭  ᪨ */
};

struct chn_data {
  chnptr  next;           /* 㪠⥫  ᫥騩  */
  word_s  port;           /*    */
  pipe    r_pipe;         /*  ਥ  裡 */
  byte  * xmit_buf;       /*   ठ */
  word    len_xmit;       /*  ।  */
  byte    flags;          /* ࠧ ਧ ( 直 砩) */
  byte    resv;           /* १ ( ࠢ  ࠭ ᫮ */
};

chnptr mpo8_install(word_s base0, byte irq, byte chn, nearptr rbuf, word rsize);
void mpo8_change_mode(chnptr pchn, word_s baud, byte len, byte par, byte stp);
void mpo8_send(chnptr pchn, char *buf, word len);
word_s mpo8_receive(chnptr pchn, long timeout);
word_s mpo8_check(chnptr pchn);
void mpo8_remove_all();
