#include  "complex.h"

extern word_s PRI_OFF;

char typc[18][5] = { "110", "110", "130", "711", "VIRT", "R130",
                     "0000", "ADAM", "A813", "HART", "D512", "Y170",
                     "M612", "0000", "S7_x", "U800", "xxxx", "UMCM" };

extern int get_kfVIRT(controller *p_c, analog *p_a,void **koef);
extern int get_kfR110(controller *p_c, analog *p_a,void **koef);
extern int get_kfR130(controller *p_c, analog *p_a,void **koef);
extern int get_kfD512(controller *p_c, analog *p_a,void **koef);
extern int get_kfY170(controller *p_c, analog *p_a,void **koef);
extern int get_kfM612(controller *p_c, analog *p_a,void **koef);
extern int get_kfS7(controller *p_c, analog *p_a,void **koef);
extern int get_kfUMCM(controller *p_c, analog *p_a,void **koef);

extern int set_kfVIRT(controller *p_c, analog *p_a, word_s nom_kf, float valk);
extern int set_kfR110(controller *p_c, analog *p_a, word_s nom_kf, float valk);
extern int set_kfR130(controller *p_c, analog *p_a, word_s nom_kf, float valk);
extern int set_kfD512(controller *p_c, analog *p_a, word_s nom_kf, float valk);
extern int set_kfY170(controller *p_c, analog *p_a, word_s nom_kf, float valk);
extern int set_kfM612(controller *p_c, analog *p_a, word_s nom_kf, float valk);
extern int set_kfS7(controller *p_c, analog *p_a, word_s nom_kf, float valk);
extern int set_kfUMCM(controller *p_c, analog *p_a, word_s nom_kf, float valk);

extern int Get_info_contrVIRT(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg);
extern int Get_info_contrR110(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg);
extern int Get_info_contrR130(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg);
extern int Get_info_contrD512(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg);
extern int Get_info_contrY170(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg);
extern int Get_info_contrM612(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg);
extern int Get_info_contrS7(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg);
extern int Get_info_contrUMCM(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg);

extern word_s mode_L110(controller *, analog *, word_s );
extern word_s mode_R110(controller *, analog *, word_s );
extern word_s mode_R130(controller *, analog *, word_s );
extern word_s mode_D512(controller *, analog *, word_s );
extern word_s mode_Y170(controller *, analog *, word_s );
extern word_s mode_M612(controller *, analog *, word_s );
extern word_s mode_S7(controller *, analog *, word_s );
extern word_s mode_UMCM(controller *, analog *, word_s );

extern word_s so_L110(controller *, analog *, word_s );
extern word_s so_R110(controller *, analog *, word_s );
extern word_s so_R130(controller *, analog *, word_s );
extern word_s so_D512(controller *, analog *, word_s );
extern word_s so_Y170(controller *, analog *, word_s );
extern word_s so_M612(controller *, analog *, word_s );
extern word_s so_S7(controller *, analog *, word_s );
extern word_s so_UMCM(controller *, analog *, word_s );

//extern int so_contr_dir_VIRT(controller *, analog *, word_s);
extern int so_contr_dir_S7(controller *, analog *, word_s);

extern int SetDigVal_S7(controller *, digit *,int);
extern int SetDigVal_VIRT(controller *, digit *,int);

extern int SetAnalogVal_S7(controller *, analog *,int);
extern int SetAnalogVal_VIRT(controller *, analog *,int);

extern void insert_CIF(controller *,int n_contr,char *Basa,int mode);
extern void insert_VIRT(controller *,int n_contr,char *Basa,int mode);
extern void insert_HART(controller *,int n_contr,char *Basa,int mode);
extern void insert_S711(controller *,int n_contr,char *Basa,int mode);
extern void insert_L110(controller *,int n_contr,char *Basa,int mode);
extern void insert_R110(controller *,int n_contr,char *Basa,int mode);
extern void insert_R130(controller *,int n_contr,char *Basa,int mode);
extern void insert_ADAM(controller *,int n_contr,char *Basa,int mode);
extern void insert_D512(controller *,int n_contr,char *Basa,int mode);
extern void insert_S7(controller *,int n_contr,char *Basa,int mode);
extern void insert_U800(controller *,int n_contr,char *Basa,int mode);

extern void enable_CIF(void);
extern void enable_VIRT(void);
extern void enable_S7(void);
extern void enable_S711(void);
extern void enable_U800(void);
extern void enable_ADAM(void);
extern void enable_UMCM(void);
extern void enable_D512(void);

extern void disable_CIF(void);
extern void disable_VIRT(void);
extern void disable_S7(void);
extern void disable_S711(void);
extern void disable_U800(void);
extern void disable_UMCM(void);
extern void disable_D512(void);

extern word_s kz_mesage_R130(controller *pc,word_s kz,word_s chn,word_s);
extern word_s kz_mesage_ADAM(controller *pc,word_s kz,word_s chn,word_s);
extern word_s kz_mesage_HART(controller *pc,word_s kz,word_s chn,word_s);
extern word_s kz_mesage_D512(controller *pc,word_s kz,word_s chn,word_s);
extern word_s kz_mesage_A813(controller *pc,word_s kz,word_s chn,word_s);
extern word_s kz_mesage_S7(controller *pc,word_s kz,word_s chn,word_s);
extern word_s kz_mesage_UMCM(controller *pc,word_s kz,word_s chn,word_s);
extern word_s kz_mesage_R110(controller *pc,word_s kz,word_s chn,word_s);

extern void taskADAM(controller *ptr_c);
extern void taskL110(controller *ptr_c);
extern void taskR130(controller *ptr_c);
extern void taskB130(controller *ptr_c);
extern void taskS711(controller *ptr_c);
extern void taskVIRT(controller *ptr_c);
extern void taskA813(controller *ptr_c);
extern void taskHART(controller *ptr_c);
extern void taskR110(controller *ptr_c);
extern void taskD512(controller *ptr_c);
extern void taskY170(controller *ptr_c);
extern void taskS7(controller *ptr_c);
extern void taskU800(controller *ptr_c);
extern void taskUMCM(controller *ptr_c);

extern void ext_help_L110(byte tip,word_s nscr);
extern void ext_help_R110(byte tip,word_s nscr);
extern void ext_help_S711(byte tip,word_s nscr);
extern void ext_help_S7(byte tip,word_s nscr);
//------------ ⠭ ⮢ ஫ -----------------------
int set_kf(controller *p_c, analog *p_a, word_s nom_kf, float valk)
{
#if (ALG)
  if(p_c->typcontr==VIRT) return(set_kfVIRT(p_c,p_a,nom_kf,valk));
#endif
#if (REM110)
  if(p_c->typcontr==R110) return(set_kfR110(p_c,p_a,nom_kf,valk));
#endif
#if (REM130)
  if(p_c->typcontr==R130) return(set_kfR130(p_c,p_a,nom_kf,valk));
#endif
#if (DAM512)
  if(p_c->typcontr==D512) return(set_kfD512(p_c,p_a,nom_kf,valk));
#endif
#if (YOK170)
  if(p_c->typcontr==Y170) return(set_kfY170(p_c,p_a,nom_kf,valk));
#endif
#if (MOD612)
  if(p_c->typcontr==M612) return(set_kfM612(p_c,p_a,nom_kf,valk));
#endif
//#if (S7_300 + S7_400)
//  if(p_c->typcontr==S300 || p_c->typcontr==S400) set_kf_S7(p_c,p_a,nom_kf,valk);
//#endif
#if(S7_x)
  if(p_c->typcontr==S7xx) return(set_kfS7(p_c,p_a,nom_kf,valk));
#endif
#if (UMCMOD)
  if(p_c->typcontr==UMCM) return(set_kfUMCM(p_c,p_a,nom_kf,valk));
#endif
 return(-1);
}

//------------ 뢮 ⨪ 樥⮢ ॣ㫫 -------------------
int Get_info_contr(controller *p_c, analog *p_a,int n_mess,rec_info_reg *info_reg)
{
#if (ALG)
  if(p_c->typcontr==VIRT) return(Get_info_contrVIRT(p_c,p_a,n_mess,info_reg));
#endif
#if (REM110)
  if(p_c->typcontr==R110) return(Get_info_contrR110(p_c,p_a,n_mess,info_reg));
#endif
#if (REM130)
  if(p_c->typcontr==R130) return(Get_info_contrR130(p_c,p_a,n_mess,info_reg));
#endif
#if (DAM512)
  if(p_c->typcontr==D512) return(Get_info_contrD512(p_c,p_a,n_mess,info_reg));
#endif
#if (YOK170)
  if(p_c->typcontr==Y170) return(Get_info_contrY170(p_c,p_a,n_mess,info_reg));
#endif
#if (MOD612)
  if(p_c->typcontr==M612) return(Get_info_contrM612(p_c,p_a,n_mess,info_reg));
#endif
//#if (S7_300 + S7_400)
//  if(p_c[nscr]->typcontr==S300 || p_c[nscr]->typcontr==S400) stat_koefS7(nscr);
//#endif
#if (S7_x)
  if(p_c->typcontr==S7xx) return(Get_info_contrS7(p_c,p_a,n_mess,info_reg));
#endif
#if (UMCMOD)
  if(p_c->typcontr==UMCM) return(Get_info_contrUMCM(p_c,p_a,n_mess,info_reg));
#endif
  return(-1);
}

//------------------- ⠭ ० ॣ ஫ ---------------
word_s mode_contr(controller *ctr , analog *anal, word_s mod)
{
#if (ALG)
  if(ctr->typcontr==VIRT) return(0);
#endif
#if (LOM110)
  if(ctr->typcontr==L110) return(mode_L110(ctr, anal, mod));
#endif
#if (REM110)
  if(ctr->typcontr==R110) return(mode_R110(ctr, anal, mod));
#endif
#if (REM130)
  if(ctr->typcontr==R130) return(mode_R130(ctr, anal, mod));
#endif
#if (DAM512)
  if(ctr->typcontr==D512) return(mode_D521(ctr, anal, mod));
#endif
#if (YOK170)
  if(ctr->typcontr==Y170) return(mode_Y170(ctr, anal, mod));
#endif
#if (MOD612)
  if(ctr->typcontr==M612) return(mode_M612(ctr, anal, mod));
#endif
//#if (S7_300)
//  if(ctr->typcontr==S300) return(mode_S7_3(ctr, anal, mod));
//#endif
//#if (S7_400)
//  if(ctr->typcontr==S400) return(mode_S7_4(ctr, anal, mod));
//#endif
#if (S7_x)
  if(ctr->typcontr==S7xx) return(mode_S7(ctr, anal, mod));
#endif
#if (UMCMOD)
  if(ctr->typcontr==UMCM) return(mode_UMCM(ctr, anal, mod));
#endif
 return(-1);
}
//---------- 㭪 뤠 ࠬ஢ ॣ  ஫ ---------------
word_s so_contr(controller *ctr, analog *anal, word_s mod)
{
#if (ALG)
  if(ctr->typcontr==VIRT) return(0);
#endif
#if (LOM110)
  if(ctr->typcontr==L110) return(so_L110(ctr, anal, mod));
#endif
#if (REM110)
  if(ctr->typcontr==R110) return(so_R110(ctr, anal, mod));
#endif
#if (REM130)
  if(ctr->typcontr==R130) return(so_R130(ctr, anal, mod));
#endif
#if (DAM512)
  if(ctr->typcontr==D512) return(so_D512(ctr, anal, mod));
#endif
#if (YOK170)
  if(ctr->typcontr==Y170) return(so_Y170(ctr, anal, mod));
#endif
#if (MOD612)
  if(ctr->typcontr==M612) return(so_M612(ctr, anal, mod));
#endif
//#if (S7_300 + S7_400)
//  if(ctr->typcontr==S300 || ctr->typcontr==S400) return(so_S7(ctr, anal, mod));
//#endif
#if (S7_x)
  if(ctr->typcontr==S7xx) return(so_S7(ctr, anal, mod));
#endif
#if (UMCMOD)
  if(ctr->typcontr==UMCM) return(so_UMCM(ctr, anal, mod));
#endif

 return(-1);
}

//-- 㭪 ࠡ⪨ ࠢ ⢨ ।⢥   ஫ ---------------
int so_contr_dir(controller *ctr, analog *anal, word_s key)
{
#if (ALG)
  if(ctr->typcontr==VIRT) return(0);
#endif
#if (S7_x)
  if(ctr->typcontr==S7xx) return(so_contr_dir_S7(ctr, anal, key));
#endif
 return(0);
}

//-------------------- ⠭ ⭮ ࠬ ----------------------------
int SetDigVal(controller *ctr, digit *p_d,int val)
{
 switch(ctr->typcontr)
 {
#if (S7_x)
  case S7xx : return(SetDigVal_S7(ctr,p_d,val));
#endif
#if (ALG)
  case VIRT : return(SetDigVal_VIRT(ctr,p_d,val));
#endif
 }
 return(-1);
}
//-------------------- ⠭  ࠬ ----------------------------
int SetAnalogVal(controller *ctr, analog *p_a,int val)
{
 switch(ctr->typcontr)
 {
#if (S7_x)
  case S7xx : return(SetAnalogVal_S7(ctr,p_a,val));
#endif
#if (ALG)
  case VIRT : return(SetAnalogVal_VIRT(ctr,p_a,val));
#endif
 }
 return(-1);
}
//-------------------- 㧪  ࠬ஢ ஫ -----------------
insert_contr(controller *ctr,int n_contr,char *Basa,int mode)
{
 switch(ctr[n_contr].typcontr)
 {
#if (CIF)
  case CIF50: insert_CIF(ctr,n_contr,Basa,mode); break;
#endif
#if (REM110)
  case R110 : insert_R110(ctr,n_contr,Basa,mode); break;
#endif
#if (LOM110)
  case L110 : insert_L110(ctr,n_contr,Basa,mode); break;
#endif
#if(REM130+REB130)
  case B130 :
  case R130 : insert_R130(ctr,n_contr,Basa,mode); break;
#endif
#if (ALG)
  case VIRT : insert_VIRT(ctr,n_contr,Basa,mode); break;
#endif
#if (PCL813+HART_M)
  case A813 :
  case HART : insert_HART(ctr,n_contr,Basa,mode); break;
#endif
#if (MIP711)
  case S711 : insert_S711(ctr,n_contr,Basa,mode); break;
#endif
#if (ADAM_Y)
  case ADAM : insert_ADAM(ctr,n_contr,Basa,mode); break;
#endif
#if (DAM512+YOK170+MOD612)
  case Y170 :
  case M612 :
  case D512 : insert_D512(ctr,n_contr,Basa,mode); break;
#endif
#if (S7_x)
  case S7xx : insert_S7(ctr,n_contr,Basa,mode); break;
#endif
//#if (S7_400)
//  case S400 : insert_A_S7_4(ctr,NamePsp); break;
//#endif
#if (UMC800+UMCMOD)
  case UMCM :
  case U800 : insert_U800(ctr,n_contr,Basa,mode); break;
#endif
 }
}
//----------------------- 祭, 樠 ஫஢ ---------
void enable_contr(void)
{
#if (CIF)
 enable_CIF();
#endif
#if (ALG)
 enable_VIRT();
#endif
#if (S7_x)
 enable_S7();
#endif
#if(MIP711 * RES711)
 enable_S711();
#endif
#if(UMC800)
 enable_U800();
#endif
#if(ADAM_Y)
 enable_ADAM();
#endif
#if(UMCMOD)
 enable_UMCM();
#endif
#if(DAM512)
 enable_D512();
#endif
#if(REM110)
 enable_R110();
#endif

}
//----------------------- 몫祭, ஫஢ ----------------------
void disable_contr(void)
{
#if (ALG)
 disable_VIRT();
#endif
#if (S7_x)
 disable_S7();
#endif
#if(MIP711 * RES711)
 disable_S711();
#endif
#if(UMC800)
 disable_U800();
#endif
#if(UMCMOD)
 disable_UMCM();
#endif
#if(DAM512)
 disable_D512();
#endif
#if (CIF)
 disable_CIF();
#endif
}
//-------------------- 뤠 ᮮ饭 訡  ஫ --------------
word_s kz_mesage_com(controller *pc,word_s kz,word_s chn,word_s kz_old)
{
 switch(pc->typcontr)
 {
#if(REM130+REB130)
  case R130 :
  case B130 : return(kz_mesage_R130(pc,kz,chn,kz_old));
#endif
#if(ADAM_Y)
  case ADAM : return(kz_mesage_ADAM(pc,kz,chn,kz_old));
#endif
#if(HART_M)
  case HART : return(kz_mesage_HART(pc,kz,chn,kz_old));
#endif
#if(DAM512+YOK170+MOD612)
  case D512 :
  case Y170 :
  case M612 : return(kz_mesage_D512(pc,kz,chn,kz_old));
#endif
#if (PCL813)
  case A813 : return(kz_mesage_A813(pc,kz,chn,kz_old));
#endif
#if (S7_x)
  case S7xx : return(kz_mesage_S7(pc,kz,chn,kz_old));
#endif
//#if (S7_300+S7_400+UMC800)
//  case S300 :
//  case S400 :
//  case U800 : return(kz_mesage_S300(pc,kz,chn,kz_old));
//#endif
#if(UMCMOD)
  case UMCM : return(kz_mesage_UMCM(pc,kz,chn,kz_old));
#endif
#if (LOM110+REM110+MIP711)
  case L110 :
  case R110 :
  case S711 : return(kz_mesage_R110(pc,kz,chn,kz_old));
#endif
 }
 return(0);
}
//---------------------   ஫஢ --------------------------
void create_task_contr(controller *ptr_c,char *name)
{
 switch(ptr_c->typcontr)
 {
#if (LOM110)
  case L110: sprintf(name,"L110-%1d",ptr_c->nomcontr);
             ptr_c->task=create_task(NULL,taskL110,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
             break;
#endif
#if (ADAM_Y)
  case ADAM: sprintf(name,"ADAM-%1d",ptr_c->nomcontr);
             ptr_c->task=create_task(NULL,taskADAM,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
             break;
#endif
#if (REM110)
  case R110: sprintf(name,"R110-%1d",ptr_c->nomcontr);
             ptr_c->task=create_task(NULL,taskR110,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
             break;
#endif
#if (REM130)
  case R130: sprintf(name,"R130-%1d",ptr_c->nomcontr);
             ptr_c->task=create_task(NULL,taskR130,STK_TSK,1536,PRI_STD-PRI_OFF+15,ptr_c,name);
             break;
#endif
#if (REB130)
  case B130 : sprintf(name,"B130-%1d",ptr_c->nomcontr);
              ptr_c->task=create_task(NULL,taskB130,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
              break;
#endif
#if (MIP711)
  case S711 : sprintf(name,"S711-%1d",ptr_c->nomcontr);
              ptr_c->task=create_task(NULL,taskS711,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
              break;
#endif
#if (ALG)
   case VIRT : sprintf(name,"VIRT-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskVIRT,NULL,5000,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
#if (PCL813)
   case A813 : sprintf(name,"A813-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskA813,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
#if (HART_M)
   case HART : sprintf(name,"HART-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskHART,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
#if (DAM512)
   case D512 : sprintf(name,"D512-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskD512,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
#if (YOK170)
   case Y170 : sprintf(name,"Y170-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskY170,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
#if (MOD612)
   case M612 : sprintf(name,"M612-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskM612,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
#if(S7_x)
   case S7xx : sprintf(name,"S7_x-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskS7,NULL,5000,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
//#if (S7_400)
//   case S400 : sprintf(name,"S400-%1d",ptr_c->nomcontr);
//               ptr_c->task=create_task(NULL,taskS400,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
//               break;
//#endif
#if (UMC800)
   case U800 : sprintf(name,"U800-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskU800,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
#if (UMCMOD)
   case UMCM : sprintf(name,"UMCM-%1d",ptr_c->nomcontr);
               ptr_c->task=create_task(NULL,taskUMCM,NULL,STK_TSK,PRI_STD-PRI_OFF+15,ptr_c,name);
               break;
#endif
 }
}
//-------------------------- ७   ஫ -----------------------
void ext_help_contr(byte tip,word_s nscr)
{
 switch(p_c[nscr]->typcontr)
 {
#if (LOM110)
  case L110 : ext_help_L110(tip,nscr); break;
#endif
#if (REM110)
  case R110 : ext_help_R110(tip,nscr); break;
#endif
#if (MIP711)
  case S711 : ext_help_S711(tip,nscr); break;
#endif
#if(S7_x)
  case S7xx : ext_help_S7(tip,nscr); break;
#endif
 }
}

int get_kf(controller *p_c, analog *p_a,void **koef)
{
#if (ALG)
  if(p_c->typcontr==VIRT) return(get_kfVIRT(p_c,p_a,koef));
#endif
#if (REM110)
  if(p_c->typcontr==R110) return(get_kfR110(p_c,p_a,koef));
#endif
#if (REM130)
  if(p_c->typcontr==R130) return(get_kfR130(p_c,p_a,koef));
#endif
#if (DAM512)
  if(p_c->typcontr==D512) return(get_kfD512(p_c,p_a,koef));
#endif
#if (YOK170)
  if(p_c->typcontr==Y170) return(get_kfY170(p_c,p_a,koef));
#endif
#if (MOD612)
  if(p_c->typcontr==M612) return(get_kfM612(p_c,p_a,koef));
#endif
//#if (S7_300 + S7_400)
//  if(p_c[nscr]->typcontr==S300 || p_c[nscr]->typcontr==S400) return(get_kfS7(nscr,koef));
//#endif
#if(S7_x)
  if(p_c->typcontr==S7xx) return(get_kfS7(p_c,p_a,koef));
#endif
#if (UMCMOD)
  if(p_c->typcontr==UMCM) return(get_kfUMCM(p_c,p_a,koef));
#endif
 return(NULL);
}
